/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.jbpm.graph.exe.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ProcessUtil {
    public static final String CURRENT_STATE = "exo:currentState".intern();
    public static final String CURRENT_LOCATION = "exo:currentLocation".intern();
    public static final String REQUEST_FOR_VALIDATION = "Request For Validation".intern();
    public static final String VALIDATED = "Validated".intern();
    public static final String PENDING = "Waiting For Publishing".intern();
    public static final String REFUSED = "Refused".intern();
    public static final String DISAPPROVED = "Disapproved".intern();
    public static final String DELEGATED = "Delegated".intern();
    public static final String ABORTED = "Aborted".intern();
    public static final String EXPIRED = "Expired".intern();
    public static final String LIVE = "Live".intern();
    public static final String BACKUP = "Backup".intern();
    public static final String IN_TRASH = "In Trash".intern();
    public static final String EXO_PUBLISH_LOCATION = "exo:publishLocation".intern();
    public static final String EXO_PENDING_LOCATION = "exo:pendingLocation".intern();
    public static final String EXO_BACKUP_LOCATION = "exo:backupLocation".intern();
    public static final String EXO_TRASH_LOCATION = "exo:trashLocation".intern();
    public static final String ACTION_REASON = "exo:actionComment".intern();
    public static final int REPOSITORY_INDEX = 0;
    public static final int WORKSPACE_INDEX = 1;
    public static final int PATH_INDEX = 2;
    public static final String EXO_VALIDATIONREQUEST = "exo:validationRequest".intern();
    public static final String EXO_CONENT_STATE = "exo:publishingState".intern();
    public static final String CURRENT_STATE_PROP = "exo:currentState".intern();
    public static final String CURRENT_WORKSPACE_PROP = "exo:currentWorkspace".intern();
    public static final String CURRENT_REPOSITORY_PROP = "exo:currentRepository".intern();
    public static final String CURRENT_PATH_PROP = "exo:currentPath".intern();
    private static Log log = ExoLogger.getLogger(ProcessUtil.class);

    public static void requestForValidation(ExecutionContext context) {
        context.setVariable(CURRENT_STATE, (Object)REQUEST_FOR_VALIDATION);
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node requestNode = ProcessUtil.getNode((String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!requestNode.isNodeType(EXO_CONENT_STATE)) {
                requestNode.addMixin(EXO_CONENT_STATE);
                requestNode.save();
            }
            requestNode.setProperty(CURRENT_STATE, REQUEST_FOR_VALIDATION);
            if (!requestNode.isNodeType(EXO_VALIDATIONREQUEST)) {
                requestNode.addMixin(EXO_VALIDATIONREQUEST);
            }
            String requester = ((ExtendedNode)requestNode).getProperty("exo:owner").getString();
            requestNode.setProperty("exo:requester", requester);
            requestNode.setProperty("exo:requestDate", (Calendar)new GregorianCalendar());
            requestNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        provider.close();
    }

    public static void approve(ExecutionContext context) {
        context.setVariable(CURRENT_STATE, (Object)VALIDATED);
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node validatedNode = ProcessUtil.getNode((String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!validatedNode.isNodeType("exo:approved")) {
                validatedNode.addMixin("exo:approved");
                validatedNode.save();
            }
            validatedNode.setProperty("exo:approver", ProcessUtil.getActorId((ExecutionContext)context));
            validatedNode.setProperty("exo:approvedDate", (Calendar)new GregorianCalendar());
            String approveComment = (String)context.getVariable(ACTION_REASON);
            if (approveComment != null && approveComment.length() != 0) {
                validatedNode.setProperty("exo:approvedComment", approveComment);
            }
            validatedNode.setProperty(CURRENT_STATE_PROP, "Approved");
            validatedNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        provider.close();
    }

    public static void disapprove(ExecutionContext context) {
        context.setVariable(CURRENT_STATE, (Object)DISAPPROVED);
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node disapprovedNode = ProcessUtil.getNode((String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!disapprovedNode.isNodeType("exo:disapproved")) {
                disapprovedNode.addMixin("exo:disapproved");
                disapprovedNode.save();
            }
            disapprovedNode.setProperty("exo:contradictor", ProcessUtil.getActorId((ExecutionContext)context));
            disapprovedNode.setProperty("exo:disaprovedDate", (Calendar)new GregorianCalendar());
            String approveComment = (String)context.getVariable(ACTION_REASON);
            if (approveComment != null && approveComment.length() != 0) {
                disapprovedNode.setProperty("exo:disapprovedReason", approveComment);
            }
            disapprovedNode.setProperty(CURRENT_STATE_PROP, "Disapproved");
            disapprovedNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        provider.close();
    }

    public static void publish(ExecutionContext context) {
        context.setVariable(CURRENT_STATE, (Object)DISAPPROVED);
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node publishedNode = ProcessUtil.getNode((String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!publishedNode.isNodeType("exo:published")) {
                publishedNode.addMixin("exo:published");
                publishedNode.save();
            }
            Date startDate = (Date)context.getVariable("startDate");
            Date endDate = (Date)context.getVariable("endDate");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startDate);
            publishedNode.setProperty("exo:startPublication", (Calendar)calendar);
            if (endDate != null) {
                calendar.setTime(endDate);
                publishedNode.setProperty("exo:endPublication", (Calendar)new GregorianCalendar());
            }
            publishedNode.setProperty(CURRENT_STATE_PROP, LIVE);
            publishedNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        provider.close();
    }

    public static void waitForPublish(ExecutionContext context) {
        context.setVariable(CURRENT_STATE, (Object)PENDING);
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node pendingNode = ProcessUtil.getNode((String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!pendingNode.isNodeType("exo:pending")) {
                pendingNode.addMixin("exo:pending");
                pendingNode.save();
            }
            Date startDate = (Date)context.getVariable("startDate");
            pendingNode.setProperty("exo:pendingStart", (Calendar)new GregorianCalendar());
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startDate);
            pendingNode.setProperty("exo:pendingEnd", (Calendar)calendar);
            pendingNode.setProperty(CURRENT_STATE_PROP, PENDING);
            pendingNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        provider.close();
    }

    public static void delegate(ExecutionContext context) {
        context.setVariable(CURRENT_STATE, (Object)DELEGATED);
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node delegateNode = ProcessUtil.getNode((String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!delegateNode.isNodeType("exo:delegated")) {
                delegateNode.addMixin("exo:delegated");
                delegateNode.save();
            }
            delegateNode.setProperty("exo:assigner", ProcessUtil.getActorId((ExecutionContext)context));
            delegateNode.setProperty("exo:delegatedDate", (Calendar)new GregorianCalendar());
            String delegator = (String)context.getVariable("delegator");
            delegateNode.setProperty("exo:delegator", delegator);
            String delegatedComment = (String)context.getVariable(ACTION_REASON);
            if (delegatedComment != null && delegatedComment.length() != 0) {
                delegateNode.setProperty("exo:delegatedComment", delegatedComment);
            }
            delegateNode.setProperty(CURRENT_STATE_PROP, DELEGATED);
            delegateNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        provider.close();
    }

    public static void backup(ExecutionContext context) {
        context.setVariable(CURRENT_STATE, (Object)BACKUP);
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node backupNode = ProcessUtil.getNode((String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!backupNode.isNodeType("exo:backup")) {
                backupNode.addMixin("exo:backup");
                backupNode.save();
            }
            backupNode.setProperty("exo:backupDate", (Calendar)new GregorianCalendar());
            backupNode.setProperty("exo:backupReason", "DOCUMENT EXPIRED");
            backupNode.setProperty(CURRENT_STATE_PROP, BACKUP);
            backupNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        provider.close();
    }

    public static void moveTrash(ExecutionContext context) {
        String sourceTransition = (String)context.getVariable(CURRENT_STATE);
        context.setVariable(CURRENT_STATE, (Object)IN_TRASH);
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node trashNode = ProcessUtil.getNode((String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!trashNode.isNodeType("exo:trashMovement")) {
                trashNode.addMixin("exo:trashMovement");
                trashNode.save();
            }
            trashNode.setProperty("exo:moveDate", (Calendar)new GregorianCalendar());
            trashNode.setProperty("exo:moveReason", sourceTransition);
            trashNode.setProperty(CURRENT_STATE_PROP, IN_TRASH);
            trashNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        provider.close();
    }

    public static Node getNode(String repositoryName, String workspace, String path, SessionProvider provider) throws Exception {
        RepositoryService repositoryService = (RepositoryService)ProcessUtil.getService(RepositoryService.class);
        ManageableRepository repository = repositoryService.getRepository(repositoryName);
        Session session = provider.getSession(workspace, repository);
        return (Node)session.getItem(path);
    }

    public static String getActorId(ExecutionContext context) {
        return (String)context.getVariable("initiator");
    }

    public static void setCurrentLocation(ExecutionContext context, String currentWorkspace, String currentPath) {
        String repository = (String)context.getVariable("repository");
        StringBuilder locationBuilder = new StringBuilder();
        locationBuilder.append(repository).append("::").append(currentWorkspace).append("::").append(currentPath);
        context.setVariable(CURRENT_LOCATION, (Object)locationBuilder.toString());
    }

    public static String[] getCurrentLocation(ExecutionContext context) {
        String currentLocation = (String)context.getVariable(CURRENT_LOCATION);
        return currentLocation.split("::");
    }

    public static <T> T getService(Class<T> type) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return type.cast(container.getComponentInstanceOfType(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAuthor(ExecutionContext context) {
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node node = ProcessUtil.getNode((String)location[0], (String)location[1], (String)location[2], (SessionProvider)provider);
            String string = node.getProperty("exo:owner").getString();
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            provider.close();
        }
        return ProcessUtil.getActorId((ExecutionContext)context);
    }

    public static String computeDestinationPath(String srcPath, String destPath) {
        String datePath = ProcessUtil.getDateLocation();
        String nodeName = srcPath.substring(srcPath.lastIndexOf("/") + 1);
        String realDestPath = destPath.endsWith("/") ? destPath.concat(datePath).concat(nodeName) : destPath.concat("/").concat(datePath).concat(nodeName);
        return realDestPath;
    }

    public static String getDateLocation() {
        LocaleConfigService configService = (LocaleConfigService)ProcessUtil.getService(LocaleConfigService.class);
        Locale locale = configService.getDefaultLocaleConfig().getLocale();
        GregorianCalendar calendar = new GregorianCalendar(locale);
        String[] monthNames = new DateFormatSymbols().getMonths();
        String currentYear = Integer.toString(calendar.get(1));
        String currentMonth = monthNames[calendar.get(2)];
        int weekday = calendar.get(7);
        int diff = 2 - weekday;
        ((Calendar)calendar).add(5, diff);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        String startDateOfWeek = dateFormat.format(calendar.getTime());
        String[] arrStartDate = startDateOfWeek.split("/");
        String startWeekDay = arrStartDate[0];
        ((Calendar)calendar).add(5, 6);
        String endDateOfWeek = dateFormat.format(calendar.getTime());
        String[] arrEndDate = endDateOfWeek.split("/");
        String endWeekDay = arrEndDate[0];
        StringBuilder builder = new StringBuilder();
        builder.append(currentYear).append("/").append(currentMonth).append("/").append(startWeekDay).append(" ").append(currentMonth).append("-").append(endWeekDay).append(" ").append(currentMonth).append(" ").append(currentYear).append("/");
        return builder.toString();
    }
}

