/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.hibernate.cfg.Configuration;
import org.jbpm.db.JbpmSessionFactory;

public abstract class AntTaskJbpmSessionFactory {
    private static final Map jbpmSessionFactoryCache = new HashMap();
    private static final Map configurationCache = new HashMap();
    private static final Log log = LogFactory.getLog(AntTaskJbpmSessionFactory.class);

    public static JbpmSessionFactory getJbpmSessionFactory(String cfg, String properties) {
        JbpmSessionFactory jbpmSessionFactory = null;
        List key = AntTaskJbpmSessionFactory.getKey(cfg, properties);
        log.debug((Object)("checking jbpm session factory cache for key " + key));
        log.debug((Object)("jbpm session factory cache: " + jbpmSessionFactoryCache));
        if (jbpmSessionFactoryCache.containsKey(key)) {
            log.debug((Object)"getting jbpm session factory from cache");
            jbpmSessionFactory = (JbpmSessionFactory)jbpmSessionFactoryCache.get(key);
        } else {
            log.debug((Object)"creating new jbpm session factory");
            jbpmSessionFactory = AntTaskJbpmSessionFactory.createJbpmSessionFactory(cfg, properties);
            jbpmSessionFactoryCache.put(key, jbpmSessionFactory);
        }
        return jbpmSessionFactory;
    }

    public static Configuration getConfiguration(String cfg, String properties) {
        Configuration configuration = null;
        List key = AntTaskJbpmSessionFactory.getKey(cfg, properties);
        log.debug((Object)("checking hibernate config cache for key " + key));
        log.debug((Object)("hibernate config cache: " + configurationCache));
        if (configurationCache.containsKey(key)) {
            log.debug((Object)"getting hibernate config from cache");
            configuration = (Configuration)configurationCache.get(key);
        } else {
            log.debug((Object)"creating new hibernate config");
            configuration = AntTaskJbpmSessionFactory.createConfiguration(cfg, properties);
            configurationCache.put(key, configuration);
        }
        return configuration;
    }

    private static List getKey(String cfg, String properties) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(cfg);
        key.add(properties);
        return key;
    }

    private static JbpmSessionFactory createJbpmSessionFactory(String cfg, String properties) {
        JbpmSessionFactory jbpmSessionFactory = null;
        try {
            Configuration configuration = AntTaskJbpmSessionFactory.getConfiguration(cfg, properties);
            jbpmSessionFactory = new JbpmSessionFactory(configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("couldn't create JbpmSessionFactory: " + e.getMessage());
        }
        return jbpmSessionFactory;
    }

    private static Configuration createConfiguration(String cfg, String properties) {
        Configuration configuration = null;
        try {
            if (cfg != null) {
                File cfgFile = new File(cfg);
                log.debug((Object)("using '" + cfgFile + "' for hibernate configuration"));
                configuration = new Configuration().configure(cfgFile);
            } else {
                log.debug((Object)"using the default jbpm configured hibernate configuration");
                configuration = JbpmSessionFactory.createConfiguration();
            }
            if (properties != null) {
                FileInputStream inputStream = new FileInputStream(new File(properties));
                Properties props = new Properties();
                props.load(inputStream);
                configuration.setProperties(props);
            }
            List key = AntTaskJbpmSessionFactory.getKey(cfg, properties);
            configurationCache.put(key, configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("couldn't create configuration: " + e.getMessage());
        }
        return configuration;
    }
}

