/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.jbpm.ant.AntTaskJbpmSessionFactory;
import org.jbpm.db.JbpmSessionFactory;
import org.jbpm.jpdl.par.ProcessArchiveDeployer;

public class DeployParTask
extends MatchingTask {
    private String cfg = null;
    private String properties = null;
    private String par = null;
    private List fileSets = new ArrayList();

    public void execute() throws BuildException {
        try {
            JbpmSessionFactory jbpmSessionFactory = AntTaskJbpmSessionFactory.getJbpmSessionFactory(this.cfg, this.properties);
            if (this.par != null) {
                this.log("deploying par " + this.par + " ...");
                File file = new File(this.par);
                this.deploy(file, jbpmSessionFactory);
            }
            for (FileSet fileSet : this.fileSets) {
                DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] fileSetFiles = dirScanner.getIncludedFiles();
                for (int i = 0; i < fileSetFiles.length; ++i) {
                    String fileName = fileSetFiles[i];
                    File file = new File(fileName);
                    if (!file.isFile()) {
                        file = new File(dirScanner.getBasedir(), fileName);
                    }
                    this.log("deploying process archive " + file + " ...");
                    this.deploy(file, jbpmSessionFactory);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("couldn't deploy process archives : " + e.getMessage());
        }
    }

    private void deploy(File file, JbpmSessionFactory jbpmSessionFactory) throws IOException, FileNotFoundException {
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        ProcessArchiveDeployer.deployZipInputStream(zipInputStream, jbpmSessionFactory);
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setCfg(String cfg) {
        this.cfg = cfg;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setPar(String par) {
        this.par = par;
    }
}

