/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.log.VariableCreateLog;
import org.jbpm.context.log.VariableDeleteLog;
import org.jbpm.graph.exe.Token;

public class TokenVariableMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected Token token = null;
    protected ContextInstance contextInstance = null;
    protected Map variableInstances = null;

    public TokenVariableMap() {
    }

    public TokenVariableMap(Token token, ContextInstance contextInstance) {
        this.token = token;
        this.contextInstance = contextInstance;
    }

    public void createVariableInstance(String name, Object value) {
        if (value == null) {
            throw new RuntimeException("can't create jbpm process variable '" + name + "' with a null value");
        }
        VariableInstance variableInstance = VariableInstance.create(this, name, value.getClass());
        this.addVariableInstance(variableInstance);
        this.token.addLog(new VariableCreateLog(variableInstance));
        variableInstance.setValue(value);
    }

    public void addVariableInstance(VariableInstance variableInstance) {
        if (variableInstance == null) {
            throw new NullPointerException("variableInstance is null");
        }
        if (variableInstance.getName() == null) {
            throw new IllegalArgumentException("variableInstance does not have a name");
        }
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap();
        }
        this.variableInstances.put(variableInstance.getName(), variableInstance);
    }

    public Object getVariable(String name) {
        Object value = null;
        VariableInstance variableInstance = this.getVariableInstance(name);
        value = variableInstance != null ? variableInstance.getValue() : (this.token.isRoot() ? null : this.getParentMap().getVariable(name));
        return value;
    }

    public void setVariable(String name, Object value) {
        VariableInstance variableInstance = this.getVariableInstance(name);
        if (variableInstance != null) {
            variableInstance.setValue(value);
        } else if (this.token.isRoot()) {
            this.createVariableInstance(name, value);
        } else {
            this.getParentMap().setVariable(name, value);
        }
    }

    public boolean hasVariable(String name) {
        boolean hasVariable = false;
        VariableInstance variableInstance = this.getVariableInstance(name);
        if (variableInstance != null) {
            hasVariable = true;
        } else if (!this.token.isRoot()) {
            hasVariable = this.getParentMap().hasVariable(name);
        }
        return hasVariable;
    }

    public void addVariables(Map variables) {
        if (variables != null) {
            for (Map.Entry entry : variables.entrySet()) {
                this.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void deleteVariable(String name) {
        VariableInstance variableInstance;
        if (this.variableInstances != null && (variableInstance = (VariableInstance)this.variableInstances.remove(name)) != null) {
            variableInstance.removeTokenVariableMapReference();
            this.token.addLog(new VariableDeleteLog(variableInstance));
        }
    }

    void collectAllVariables(Map variables) {
        if (this.variableInstances != null) {
            for (VariableInstance variableInstance : this.variableInstances.values()) {
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        if (!this.token.isRoot()) {
            this.getParentMap().collectAllVariables(variables);
        }
    }

    VariableInstance getVariableInstance(String name) {
        VariableInstance variableInstance = null;
        if (this.variableInstances != null) {
            variableInstance = (VariableInstance)this.variableInstances.get(name);
        }
        return variableInstance;
    }

    TokenVariableMap getParentMap() {
        Token parentToken = this.token.getParent();
        return this.contextInstance.getTokenVariableMap(parentToken);
    }

    public ContextInstance getContextInstance() {
        return this.contextInstance;
    }

    public Token getToken() {
        return this.token;
    }

    public Map getVariableInstances() {
        return this.variableInstances;
    }
}

