/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.io.Serializable;
import java.util.Iterator;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmType;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public abstract class VariableInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String name = null;
    protected Token token = null;
    protected TokenVariableMap tokenVariableMap = null;
    protected ProcessInstance processInstance = null;
    protected Converter converter = null;

    public static VariableInstance create(TokenVariableMap tokenVariableMap, String name, Class valueClass) {
        Token token = tokenVariableMap.token;
        ProcessInstance processInstance = token != null ? token.getProcessInstance() : null;
        VariableInstance variableInstance = VariableInstance.createVariableInstance(valueClass);
        variableInstance.tokenVariableMap = tokenVariableMap;
        variableInstance.token = token;
        variableInstance.processInstance = processInstance;
        variableInstance.name = name;
        return variableInstance;
    }

    protected abstract boolean supports(Class var1);

    protected abstract Object getObject();

    protected abstract void setObject(Object var1);

    public static VariableInstance createVariableInstance(Class javaType) {
        VariableInstance variableInstance = null;
        Iterator iter = JbpmType.getJbpmTypes().iterator();
        while (iter.hasNext() && variableInstance == null) {
            JbpmSession currentJbpmSession;
            JbpmType jbpmType = (JbpmType)iter.next();
            boolean isMatch = false;
            if (jbpmType.variableClass != null && jbpmType.variableClass.isAssignableFrom(javaType)) {
                isMatch = true;
            } else if (javaType.getName().equals(jbpmType.variableClassName)) {
                isMatch = true;
            } else if ("{serializable-classes}".equals(jbpmType.variableClassName)) {
                isMatch = Serializable.class.isAssignableFrom(javaType);
            } else if ("{hibernateable-long-id-classes}".equals(jbpmType.variableClassName)) {
                currentJbpmSession = JbpmSession.getCurrentJbpmSession();
                isMatch = currentJbpmSession != null && currentJbpmSession.getJbpmSessionFactory().isHibernatableWithLongId(javaType);
            } else if ("{hibernateable-string-id-classes}".equals(jbpmType.variableClassName)) {
                currentJbpmSession = JbpmSession.getCurrentJbpmSession();
                boolean bl = isMatch = currentJbpmSession != null && currentJbpmSession.getJbpmSessionFactory().isHibernatableWithStringId(javaType);
            }
            if (!isMatch) continue;
            variableInstance = VariableInstance.createVariableInstance(jbpmType);
        }
        if (variableInstance == null) {
            throw new RuntimeException("contents of jbpm.varmapping.properties does not specify how jbpm should store objects of type '" + javaType.getName() + "' in the database");
        }
        return variableInstance;
    }

    private static VariableInstance createVariableInstance(JbpmType jbpmType) {
        VariableInstance variableInstance;
        try {
            variableInstance = (VariableInstance)jbpmType.variableInstanceClass.newInstance();
            variableInstance.converter = jbpmType.converter;
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't instantiate variable instance of class '" + jbpmType.getClass().getName() + "'", e);
        }
        return variableInstance;
    }

    public void setValue(Object value) {
        if (value != null && this.converter != null) {
            if (!this.converter.supports(value.getClass())) {
                throw new RuntimeException("the converter '" + this.converter.getClass().getName() + "' in variable instance '" + this.getClass().getName() + "' does not support values of type '" + value.getClass().getName() + "'.  to change the type of a variable, you have to delete it first");
            }
            value = this.converter.convert(value);
        }
        if (value != null && !this.supports(value.getClass())) {
            throw new RuntimeException("variable instance '" + this.getClass().getName() + "' does not support values of type '" + value.getClass().getName() + "'.  to change the type of a variable, you have to delete it first");
        }
        this.setObject(value);
    }

    public Object getValue() {
        Object value = this.getObject();
        if (value != null && this.converter != null) {
            value = this.converter.revert(value);
        }
        return value;
    }

    public void removeTokenVariableMapReference() {
        this.tokenVariableMap = null;
        this.token = null;
        this.processInstance = null;
    }

    public String toString() {
        return "${" + this.name + "}";
    }

    public String getName() {
        return this.name;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public Token getToken() {
        return this.token;
    }
}

