/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.db.JbpmSession;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class TaskMgmtSession {
    JbpmSession jbpmSession = null;
    Session session = null;
    private static final String findTaskInstancesByActorId = "select ti from org.jbpm.taskmgmt.exe.TaskInstance as ti where ti.actorId = :actorId   and ti.end is null   and ti.isCancelled = false";
    private static final String findTaskInstancesByActorIds = "select ti from org.jbpm.taskmgmt.exe.TaskInstance as ti where ti.actorId in ( :actorIds )  and ti.end is null   and ti.isCancelled = false";
    private static final String findPooledTaskInstancesByActorId = "select distinct ti from org.jbpm.taskmgmt.exe.PooledActor pooledActor      join pooledActor.taskInstances ti where pooledActor.actorId = :swimlaneActorId   and ti.actorId is null   and ti.end is null   and ti.isCancelled = false";
    private static final String findPooledTaskInstancesByActorIds = "select distinct ti from org.jbpm.taskmgmt.exe.PooledActor pooledActor      join pooledActor.taskInstances ti where pooledActor.actorId in ( :actorIds )   and ti.actorId is null   and ti.end is null   and ti.isCancelled = false";
    private static final String findTaskInstancesByTokenId = "select ti from org.jbpm.taskmgmt.exe.TaskInstance ti where ti.token.id = :tokenId   and ti.end is null   and ti.isCancelled = false";
    private static final Log log = LogFactory.getLog(TaskMgmtSession.class);

    public TaskMgmtSession(JbpmSession jbpmSession) {
        this.jbpmSession = jbpmSession;
        this.session = jbpmSession.getSession();
    }

    public List findTaskInstances(String actorId) {
        List result = new ArrayList();
        try {
            Query query = this.session.createQuery(findTaskInstancesByActorId);
            query.setString("actorId", actorId);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
        }
        return result;
    }

    public List findTaskInstances(List actorIds) {
        return this.findTaskInstances(actorIds.toArray(new String[actorIds.size()]));
    }

    public List findTaskInstances(String[] actorIds) {
        List result = null;
        try {
            Query query = this.session.createQuery(findTaskInstancesByActorIds);
            query.setParameterList("actorIds", (Object[])actorIds);
            result = query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't get task instances list for actors '" + actorIds + "'", e);
        }
        return result;
    }

    public List findPooledTaskInstances(String actorId) {
        List result = null;
        try {
            Query query = this.session.createQuery(findPooledTaskInstancesByActorId);
            query.setString("swimlaneActorId", actorId);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't get pooled task instances list for actor '" + actorId + "'", e);
        }
        return result;
    }

    public List findPooledTaskInstances(List actorIds) {
        List result = null;
        try {
            Query query = this.session.createQuery(findPooledTaskInstancesByActorIds);
            query.setParameterList("actorIds", (Collection)actorIds);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't get pooled task instances list for actors '" + actorIds + "'", e);
        }
        return result;
    }

    public List findTaskInstancesByToken(long tokenId) {
        List result = null;
        try {
            Query query = this.session.createQuery(findTaskInstancesByTokenId);
            query.setLong("tokenId", tokenId);
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't get task instances by token '" + tokenId + "'", e);
        }
        return result;
    }

    public TaskInstance loadTaskInstance(long taskInstanceId) {
        TaskInstance taskInstance = null;
        try {
            taskInstance = (TaskInstance)this.session.load(TaskMgmtInstance.getTaskInstanceClass(), (Serializable)new Long(taskInstanceId));
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't get task instance '" + taskInstanceId + "'", e);
        }
        return taskInstance;
    }
}

