/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.exe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ProcessInstanceCreateLog;
import org.jbpm.graph.log.ProcessInstanceEndLog;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.logging.exe.LoggingInstance;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.scheduler.exe.SchedulerInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class ProcessInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected Date start = null;
    protected Date end = null;
    protected ProcessDefinition processDefinition = null;
    protected Token rootToken = null;
    protected Token superProcessToken = null;
    protected Map instances = null;
    protected Map transientInstances = null;
    protected List runtimeActions = null;

    public ProcessInstance() {
    }

    public ProcessInstance(ProcessDefinition processDefinition) {
        if (processDefinition == null) {
            throw new NullPointerException("can't create a process instance when processDefinition is null");
        }
        this.processDefinition = processDefinition;
        this.rootToken = new Token(this);
        this.start = new Date();
        Map definitions = processDefinition.getDefinitions();
        if (definitions != null) {
            this.instances = new HashMap();
            for (ModuleDefinition definition : definitions.values()) {
                ModuleInstance instance = definition.createInstance();
                if (instance == null) continue;
                this.addInstance(instance);
            }
        }
        this.rootToken.addLog(new ProcessInstanceCreateLog());
        JbpmSession jbpmSession = JbpmSession.getCurrentJbpmSession();
        if (jbpmSession != null) {
            jbpmSession.getSession().save((Object)this);
        }
        if (this.rootToken.getNode() != null) {
            ExecutionContext executionContext = new ExecutionContext(this.rootToken);
            processDefinition.fireEvent("process-start", executionContext);
        }
    }

    public ModuleInstance addInstance(ModuleInstance moduleInstance) {
        if (moduleInstance == null) {
            throw new IllegalArgumentException("can't add a null moduleInstance to a process instance");
        }
        if (this.instances == null) {
            this.instances = new HashMap();
        }
        this.instances.put(moduleInstance.getClass().getName(), moduleInstance);
        moduleInstance.setProcessInstance(this);
        return moduleInstance;
    }

    public ModuleInstance removeInstance(ModuleInstance moduleInstance) {
        ModuleInstance removedModuleInstance = null;
        if (moduleInstance == null) {
            throw new IllegalArgumentException("can't remove a null moduleInstance from a process instance");
        }
        if (this.instances != null && (removedModuleInstance = (ModuleInstance)this.instances.remove(moduleInstance.getClass().getName())) != null) {
            moduleInstance.setProcessInstance(null);
        }
        return removedModuleInstance;
    }

    public ModuleInstance getInstance(Class clazz) {
        ModuleInstance moduleInstance = null;
        if (this.instances != null) {
            moduleInstance = (ModuleInstance)this.instances.get(clazz.getName());
        }
        if (moduleInstance == null) {
            if (this.transientInstances == null) {
                this.transientInstances = new HashMap();
            }
            if ((moduleInstance = (ModuleInstance)this.transientInstances.get(clazz.getName())) == null) {
                try {
                    moduleInstance = (ModuleInstance)clazz.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("couldn't instantiate transient module '" + clazz.getName() + "' with the default constructor");
                }
                this.transientInstances.put(clazz.getName(), moduleInstance);
            }
        }
        return moduleInstance;
    }

    public ContextInstance getContextInstance() {
        return (ContextInstance)this.getInstance(ContextInstance.class);
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return (TaskMgmtInstance)this.getInstance(TaskMgmtInstance.class);
    }

    public LoggingInstance getLoggingInstance() {
        return (LoggingInstance)this.getInstance(LoggingInstance.class);
    }

    public SchedulerInstance getSchedulerInstance() {
        return (SchedulerInstance)this.getInstance(SchedulerInstance.class);
    }

    public void signal() {
        if (this.hasEnded()) {
            throw new IllegalStateException("couldn't signal token : token has ended");
        }
        this.rootToken.signal();
    }

    public void signal(String transitionName) {
        if (this.hasEnded()) {
            throw new IllegalStateException("couldn't signal token : token has ended");
        }
        this.rootToken.signal(transitionName);
    }

    public void signal(Transition transition) {
        if (this.hasEnded()) {
            throw new IllegalStateException("couldn't signal token : token has ended");
        }
        this.rootToken.signal(transition);
    }

    public void end() {
        this.rootToken.end();
        if (this.end == null) {
            this.end = new Date();
            ExecutionContext executionContext = new ExecutionContext(this.rootToken);
            this.processDefinition.fireEvent("process-end", executionContext);
            this.rootToken.addLog(new ProcessInstanceEndLog());
            if (this.superProcessToken != null) {
                ProcessState processState = (ProcessState)this.superProcessToken.getNode();
                processState.notifySubProcessEnd(this);
            }
            this.getSchedulerInstance().setProcessEnded(true);
        }
    }

    public RuntimeAction addRuntimeAction(RuntimeAction runtimeAction) {
        if (runtimeAction == null) {
            throw new IllegalArgumentException("can't add a null runtimeAction to a process instance");
        }
        if (this.runtimeActions == null) {
            this.runtimeActions = new ArrayList();
        }
        this.runtimeActions.add(runtimeAction);
        runtimeAction.processInstance = this;
        return runtimeAction;
    }

    public RuntimeAction removeRuntimeAction(RuntimeAction runtimeAction) {
        RuntimeAction removedRuntimeAction = null;
        if (runtimeAction == null) {
            throw new IllegalArgumentException("can't remove a null runtimeAction from an process instance");
        }
        if (this.runtimeActions != null && this.runtimeActions.remove(runtimeAction)) {
            removedRuntimeAction = runtimeAction;
            runtimeAction.processInstance = null;
        }
        return removedRuntimeAction;
    }

    public List getRuntimeActions() {
        return this.runtimeActions;
    }

    public boolean hasEnded() {
        return this.end != null;
    }

    public boolean isTerminatedImplicitly() {
        boolean isTerminatedImplicitly = true;
        if (this.end == null) {
            isTerminatedImplicitly = this.rootToken.isTerminatedImplicitly();
        }
        return isTerminatedImplicitly;
    }

    public Token findToken(String tokenPath) {
        return this.rootToken != null ? this.rootToken.findToken(tokenPath) : null;
    }

    public long getId() {
        return this.id;
    }

    public Token getRootToken() {
        return this.rootToken;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public Map getInstances() {
        return this.instances;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public Token getSuperProcessToken() {
        return this.superProcessToken;
    }

    public void setSuperProcessToken(Token superProcessToken) {
        this.superProcessToken = superProcessToken;
    }
}

