/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.impl;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.scheduler.impl.SchedulerHistoryLog;
import org.jbpm.scheduler.impl.SchedulerListener;
import org.jbpm.scheduler.impl.SchedulerThread;

public class Scheduler {
    SchedulerThread schedulerThread = null;
    LinkedList historyLogs = new LinkedList();
    int interval = 5000;
    int historyMaxSize = 30;
    private static final Log log = LogFactory.getLog(Scheduler.class);

    public void start() {
        log.debug((Object)"starting the scheduler");
        this.schedulerThread = new SchedulerThread();
        this.schedulerThread.setInterval(this.interval);
        this.schedulerThread.addListener(new HistoryListener());
        this.schedulerThread.start();
    }

    public void stop() {
        if (this.isRunning()) {
            log.debug((Object)"stopping the scheduler");
            this.schedulerThread.keepRunning = false;
            this.schedulerThread.interrupt();
            this.schedulerThread = null;
        } else {
            log.debug((Object)"scheduler can't be stopped cause it was not running");
        }
    }

    public boolean isRunning() {
        return this.schedulerThread != null && this.schedulerThread.isAlive();
    }

    public List getSchedulerHistoryLogs() {
        return this.historyLogs;
    }

    public void clearSchedulerHistoryLogs() {
        this.historyLogs.clear();
    }

    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historyMaxSize = historyMaxSize;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public SchedulerThread getSchedulerThread() {
        return this.schedulerThread;
    }

    class HistoryListener
    implements SchedulerListener {
        HistoryListener() {
        }

        public void timerExecuted(Date date, Timer timer) {
            Scheduler.this.historyLogs.add(new SchedulerHistoryLog(date, timer));
            if (Scheduler.this.historyLogs.size() > Scheduler.this.historyMaxSize) {
                Scheduler.this.historyLogs.removeLast();
            }
        }
    }
}

