/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.exe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.security.Authentication;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.jbpm.taskmgmt.log.TaskAssignLog;
import org.jbpm.taskmgmt.log.TaskEndLog;

public class TaskInstance
implements Serializable,
Assignable {
    private static final long serialVersionUID = 1L;
    private long id = 0L;
    protected String name = null;
    protected String description = null;
    protected String actorId = null;
    protected Date create = null;
    protected Date start = null;
    protected Date end = null;
    protected Date dueDate = null;
    protected int priority = 3;
    protected boolean isCancelled = false;
    protected boolean isSignalling = true;
    protected boolean isBlocking = false;
    protected Task task = null;
    protected Token token = null;
    protected SwimlaneInstance swimlaneInstance = null;
    protected TaskMgmtInstance taskMgmtInstance = null;
    protected Set pooledActors = null;
    protected List comments = null;
    protected String previousActorId = null;
    private static final Log log = LogFactory.getLog(TaskInstance.class);

    public TaskInstance() {
    }

    public TaskInstance(String taskName) {
        this.name = taskName;
    }

    public TaskInstance(String taskName, String actorId) {
        this.name = taskName;
        this.actorId = actorId;
    }

    public void setTask(Task task) {
        this.name = task.getName();
        this.description = task.getDescription();
        this.task = task;
        this.isBlocking = task.isBlocking();
        this.priority = task.getPriority();
        if (task.getTaskNode() != null) {
            int signal = task.getTaskNode().getSignal();
            boolean bl = this.isSignalling = signal == 2 || signal == 4 || signal == 3 || signal == 5;
        }
        if (task.getDueDate() != null) {
            BusinessCalendar businessCalendar = new BusinessCalendar();
            this.dueDate = businessCalendar.add(new Date(), new Duration(task.getDueDate()));
        }
    }

    public void create() {
        this.create(null);
    }

    public void create(ExecutionContext executionContext) {
        if (this.create != null) {
            throw new IllegalStateException("task instance '" + this.id + "' was already created");
        }
        this.create = new Date();
        if (this.task != null && executionContext != null) {
            executionContext.setTaskInstance(this);
            executionContext.setTask(this.task);
            this.task.fireEvent("task-create", executionContext);
        }
    }

    public void assign(ExecutionContext executionContext) {
        TaskMgmtInstance taskMgmtInstance = executionContext.getTaskMgmtInstance();
        Swimlane swimlane = this.task.getSwimlane();
        if (swimlane != null) {
            if (this.isStartTaskInstance()) {
                this.swimlaneInstance = new SwimlaneInstance(swimlane);
                taskMgmtInstance.addSwimlaneInstance(this.swimlaneInstance);
                this.swimlaneInstance.setActorId(Authentication.getAuthenticatedActorId());
            } else {
                this.swimlaneInstance = taskMgmtInstance.getInitializedSwimlaneInstance(executionContext, swimlane);
                this.copySwimlaneInstanceAssignment(this.swimlaneInstance);
            }
        } else {
            taskMgmtInstance.invokeAssignmentHandler(this.task.getAssignmentDelegation(), this, executionContext);
        }
        this.updatePooledActorsReferences(this.swimlaneInstance);
    }

    public boolean isStartTaskInstance() {
        boolean isStartTaskInstance = false;
        if (this.taskMgmtInstance != null && this.taskMgmtInstance.getTaskMgmtDefinition() != null) {
            isStartTaskInstance = this.task == this.taskMgmtInstance.getTaskMgmtDefinition().getStartTask();
        }
        return isStartTaskInstance;
    }

    private void updatePooledActorsReferences(SwimlaneInstance swimlaneInstance) {
        if (this.pooledActors != null) {
            for (PooledActor pooledActor : this.pooledActors) {
                pooledActor.setSwimlaneInstance(swimlaneInstance);
                pooledActor.addTaskInstance(this);
            }
        }
    }

    public void copySwimlaneInstanceAssignment(SwimlaneInstance swimlaneInstance) {
        this.setSwimlaneInstance(swimlaneInstance);
        this.setActorId(swimlaneInstance.actorId);
        this.setPooledActors(swimlaneInstance.pooledActors != null ? new HashSet(swimlaneInstance.pooledActors) : null);
    }

    public Set getPooledActors() {
        if (this.swimlaneInstance != null && (this.pooledActors == null || this.pooledActors.isEmpty())) {
            return this.swimlaneInstance.pooledActors;
        }
        return this.pooledActors;
    }

    public void setActorId(String actorId) {
        this.setActorId(actorId, true);
    }

    public void setActorId(String actorId, boolean overwriteSwimlane) {
        if (this.task != null && this.token != null) {
            ExecutionContext executionContext = new ExecutionContext(this.token);
            executionContext.setTask(this.task);
            executionContext.setTaskInstance(this);
            this.task.fireEvent("task-assign", executionContext);
        }
        this.previousActorId = this.actorId;
        this.actorId = actorId;
        if (this.swimlaneInstance != null && overwriteSwimlane) {
            this.swimlaneInstance.setActorId(actorId);
        }
        if (this.token != null) {
            this.token.addLog(new TaskAssignLog(this, this.previousActorId, actorId));
        }
    }

    public void setPooledActors(String[] actorIds) {
        this.pooledActors = PooledActor.createPool(actorIds);
    }

    public void start() {
        if (this.start != null) {
            throw new IllegalStateException("task instance '" + this.id + "' is already started");
        }
        this.start = new Date();
        if (this.task != null && this.token != null) {
            ExecutionContext executionContext = new ExecutionContext(this.token);
            executionContext.setTaskInstance(this);
            this.task.fireEvent("task-start", executionContext);
        }
    }

    public void start(String actorId) {
        this.setActorId(actorId);
        this.start();
    }

    public void cancel() {
        this.isCancelled = true;
        this.end();
    }

    public void end() {
        this.end((Transition)null);
    }

    public void end(String transitionName) {
        Transition leavingTransition = null;
        if (this.task != null) {
            Node node = this.task.getTaskNode();
            if (node == null) {
                node = (Node)this.task.getParent();
            }
            if (node != null) {
                leavingTransition = node.getLeavingTransition(transitionName);
            }
        }
        if (leavingTransition == null) {
            throw new NullPointerException("task node does not have leaving transition '" + transitionName + "'");
        }
        this.end(leavingTransition);
    }

    public void end(Transition transition) {
        if (this.end != null) {
            throw new IllegalStateException("task instance '" + this.id + "'is already started");
        }
        this.end = new Date();
        if (this.task != null && this.token != null) {
            ExecutionContext executionContext = new ExecutionContext(this.token);
            this.task.fireEvent("task-end", executionContext);
        }
        if (this.token != null) {
            this.token.addLog(new TaskEndLog(this));
        }
        if (this.isSignalling) {
            this.isSignalling = false;
            if (this.isStartTaskInstance() || this.task != null && this.token != null && this.task.getTaskNode() != null && this.task.getTaskNode().completionTriggersSignal(this)) {
                if (transition == null) {
                    log.debug((Object)("completion of task '" + this.task.getName() + "' results in taking the default transition"));
                    this.token.signal();
                } else {
                    log.debug((Object)("completion of task '" + this.task.getName() + "' results in taking transition '" + transition + "'"));
                    this.token.signal(transition);
                }
            }
        }
    }

    public boolean hasEnded() {
        return this.end != null;
    }

    public void addComment(String message) {
        Comment comment = new Comment(message);
        this.addComment(comment);
        if (this.token != null) {
            this.token.addComment(comment);
        }
    }

    public void addComment(Comment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(comment);
        comment.setTaskInstance(this);
        comment.setToken(this.token);
    }

    public List getComments() {
        return this.comments;
    }

    public List getTaskFormParameters() {
        List taskFormParameters = null;
        if (this.task != null && this.task.getTaskController() != null) {
            taskFormParameters = this.task.getTaskController().getTaskFormParameters(this);
        }
        return taskFormParameters;
    }

    public void submitParameters(Map parameters) {
        if (this.task != null && this.task.getTaskController() != null) {
            this.task.getTaskController().submitParameters(parameters, this);
        }
    }

    public boolean isLast() {
        return this.token != null && this.taskMgmtInstance != null && !this.taskMgmtInstance.hasUnfinishedTasks(this.token);
    }

    public List getAvailableTransitions() {
        ArrayList transitions = null;
        if (!this.isLast() && this.token != null) {
            transitions = new ArrayList(this.token.getNode().getLeavingTransitions());
        }
        return transitions;
    }

    public String getActorId() {
        return this.actorId;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setCreate(Date create) {
        this.create = create;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getStart() {
        return this.start;
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return this.taskMgmtInstance;
    }

    public void setTaskMgmtInstance(TaskMgmtInstance taskMgmtInstance) {
        this.taskMgmtInstance = taskMgmtInstance;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setSignalling(boolean isSignalling) {
        this.isSignalling = isSignalling;
    }

    public boolean isSignalling() {
        return this.isSignalling;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    public Date getCreate() {
        return this.create;
    }

    public Task getTask() {
        return this.task;
    }

    public void setPooledActors(Set pooledActors) {
        this.pooledActors = pooledActors;
    }

    public SwimlaneInstance getSwimlaneInstance() {
        return this.swimlaneInstance;
    }

    public void setSwimlaneInstance(SwimlaneInstance swimlaneInstance) {
        this.swimlaneInstance = swimlaneInstance;
    }

    public String getPreviousActorId() {
        return this.previousActorId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

