/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.ColorSpaceWrapper;
import org.icepdf.core.util.Library;

public class ICCBased
extends PColorSpace {
    private static final Logger logger = Logger.getLogger(ICCBased.class.toString());
    int numcomp;
    PColorSpace alternate;
    Stream stream;
    ColorSpace colorSpace;
    private float[] lastInput;
    private Color lastOutput;

    public ICCBased(Library library, Stream stream) {
        super(library, stream.getEntries());
        this.numcomp = stream.getInt("N");
        switch (this.numcomp) {
            case 1: {
                this.alternate = new DeviceGray(library, null);
                break;
            }
            case 3: {
                this.alternate = new DeviceRGB(library, null);
                break;
            }
            case 4: {
                this.alternate = new DeviceCMYK(library, null);
            }
        }
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        InputStream inputStream = null;
        try {
            this.stream.init();
            inputStream = this.stream.getInputStreamForDecodedStreamBytes();
            if (inputStream != null) {
                this.colorSpace = ColorSpaceWrapper.getICCColorSpaceInstance(inputStream);
            }
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error Processing ICCBased Colour Profile", exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor(float[] fArray) {
        this.init();
        if (this.colorSpace != null) {
            try {
                ICCBased iCCBased = this;
                synchronized (iCCBased) {
                    int n;
                    int n2;
                    if (this.lastOutput != null && this.lastInput != null && fArray != null && this.lastInput.length == fArray.length) {
                        n2 = 1;
                        int n3 = this.lastInput.length;
                        for (n = n3 - 1; n >= 0; --n) {
                            if (fArray[n] == this.lastInput[n]) continue;
                            n2 = 0;
                            break;
                        }
                        if (n2 != 0) {
                            return this.lastOutput;
                        }
                    }
                    n2 = this.colorSpace.getNumComponents();
                    float[] fArray2 = new float[n2];
                    int n4 = fArray.length;
                    n = n2;
                    if (n4 < n) {
                        // empty if block
                    }
                    n = n4;
                    for (int i = 0; i < n; ++i) {
                        float f = fArray[n4 - 1 - i];
                        if (f < 0.0f) {
                            f = 0.0f;
                        } else if (f > 1.0f) {
                            f = 1.0f;
                        }
                        fArray2[i] = f;
                    }
                    float[] fArray3 = this.colorSpace.toRGB(fArray2);
                    int n5 = 0xFF000000 | ((int)(fArray3[0] * 255.0f) & 0xFF) << 16 | ((int)(fArray3[1] * 255.0f) & 0xFF) << 8 | ((int)(fArray3[2] * 255.0f) & 0xFF) << 0;
                    Color color = new Color(n5);
                    if (this.lastInput == null || this.lastInput.length != n4) {
                        this.lastInput = new float[n4];
                    }
                    for (int i = n4 - 1; i >= 0; --i) {
                        this.lastInput[i] = fArray[i];
                    }
                    this.lastOutput = color;
                    return color;
                }
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Error getting ICCBased colour", exception);
            }
        }
        return this.alternate.getColor(fArray);
    }

    public int getNumComponents() {
        return this.numcomp;
    }
}

