/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.ObjectStream;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.MemoryManagerDelegate;
import org.icepdf.core.util.Parser;

public class LazyObjectLoader
implements MemoryManagerDelegate {
    private static final Logger logger = Logger.getLogger(LazyObjectLoader.class.toString());
    private Library library;
    private SeekableInput m_SeekableInput;
    private CrossReference m_CrossReference;
    protected ArrayList<ObjectStream> leastRecentlyUsed;
    private final Object leastRectlyUsedLock = new Object();

    public LazyObjectLoader(Library library, SeekableInput seekableInput, CrossReference crossReference) {
        this.library = library;
        this.m_SeekableInput = seekableInput;
        this.m_CrossReference = crossReference;
        this.leastRecentlyUsed = new ArrayList(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadObject(Reference reference) {
        if (reference == null) return false;
        if (this.library == null) return false;
        if (this.m_CrossReference == null) {
            return false;
        }
        int n = reference.getObjectNumber();
        CrossReference.Entry entry = this.m_CrossReference.getEntryForObject(n);
        if (entry == null) {
            return false;
        }
        boolean bl = false;
        if (entry instanceof CrossReference.UsedEntry) {
            try {
                if (this.m_SeekableInput == null) return bl;
                this.m_SeekableInput.beginThreadAccess();
                CrossReference.UsedEntry usedEntry = (CrossReference.UsedEntry)entry;
                long l = usedEntry.getFilePositionOfObject();
                long l2 = this.m_SeekableInput.getAbsolutePosition();
                this.m_SeekableInput.seekAbsolute(l);
                Parser parser = new Parser(this.m_SeekableInput);
                Object object = parser.getObject(this.library);
                bl = object != null;
                this.m_SeekableInput.seekAbsolute(l2);
                return bl;
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Error loading object instance: " + reference.toString(), exception);
                return bl;
            }
            finally {
                if (this.m_SeekableInput != null) {
                    this.m_SeekableInput.endThreadAccess();
                }
            }
        }
        if (!(entry instanceof CrossReference.CompressedEntry)) return bl;
        try {
            CrossReference.CompressedEntry compressedEntry = (CrossReference.CompressedEntry)entry;
            int n2 = compressedEntry.getObjectNumberOfContainingObjectStream();
            int n3 = compressedEntry.getIndexWithinObjectStream();
            Reference reference2 = new Reference(n2, 0);
            ObjectStream objectStream = (ObjectStream)this.library.getObject(reference2);
            if (objectStream == null) return bl;
            Object object = this.leastRectlyUsedLock;
            synchronized (object) {
                this.leastRecentlyUsed.remove(objectStream);
                this.leastRecentlyUsed.add(objectStream);
                return objectStream.loadObject(this.library, n3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error loading object instance: " + reference.toString(), exception);
        }
        return bl;
    }

    public boolean haveEntry(Reference reference) {
        if (reference == null || this.m_CrossReference == null) {
            return false;
        }
        int n = reference.getObjectNumber();
        CrossReference.Entry entry = this.m_CrossReference.getEntryForObject(n);
        return entry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTrailer loadTrailer(long l) {
        PTrailer pTrailer = null;
        try {
            if (this.m_SeekableInput != null) {
                this.m_SeekableInput.beginThreadAccess();
                long l2 = this.m_SeekableInput.getAbsolutePosition();
                this.m_SeekableInput.seekAbsolute(l);
                Parser parser = new Parser(this.m_SeekableInput);
                Object object = parser.getObject(this.library);
                if (object instanceof PObject) {
                    object = ((PObject)object).getObject();
                }
                pTrailer = (PTrailer)object;
                this.m_SeekableInput.seekAbsolute(l2);
            }
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error loading PTrailer instance: " + l, exception);
        }
        finally {
            if (this.m_SeekableInput != null) {
                this.m_SeekableInput.endThreadAccess();
            }
        }
        return pTrailer;
    }

    public void dispose() {
        this.library = null;
        this.m_SeekableInput = null;
        this.m_CrossReference = null;
        if (this.leastRecentlyUsed != null) {
            this.leastRecentlyUsed.clear();
            this.leastRecentlyUsed = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reduceMemory(int n) {
        int n2 = 0;
        Object object = this.leastRectlyUsedLock;
        synchronized (object) {
            int n3 = this.leastRecentlyUsed.size();
            if (n == 1) {
                n2 = n3 * 75 / 100;
            } else if (n == 0) {
                if (n3 > 5) {
                    n2 = n3 * 50 / 100;
                } else if (n3 > 0) {
                    n2 = 1;
                }
            }
            for (int i = 0; i < n2; ++i) {
                ObjectStream objectStream = this.leastRecentlyUsed.remove(0);
                if (objectStream == null) continue;
                objectStream.dispose(true);
            }
        }
        return n2 > 0;
    }

    public Library getLibrary() {
        return this.library;
    }
}

