/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class SetCurrentIdentityFilter
extends AbstractFilter {
    private static Log log = ExoLogger.getLogger((String)"core.security.SetCurrentIdentityFilter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExoContainer container = this.getContainer();
        try {
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            ConversationState state = this.getCurrentState(container, httpRequest);
            ConversationState.setCurrent(state);
            if (state != null && log.isDebugEnabled()) {
                log.debug((Object)(">>> Memberships " + state.getIdentity().getMemberships()));
            }
            chain.doFilter(request, response);
        }
        finally {
            try {
                ConversationState.setCurrent(null);
            }
            catch (Exception e) {
                log.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
            try {
                ExoContainerContext.setCurrentContainer(null);
            }
            catch (Exception e) {
                log.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    private ConversationState getCurrentState(ExoContainer container, HttpServletRequest httpRequest) {
        ConversationRegistry conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        ConversationState state = null;
        String userId = httpRequest.getRemoteUser();
        if (userId != null) {
            HttpSession httpSession = httpRequest.getSession();
            HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for Conversation State " + httpSession.getId()));
            }
            if ((state = conversationRegistry.getState(stateKey)) == null) {
                Identity identity;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Conversation State not found, try create new one.");
                }
                if ((identity = identityRegistry.getIdentity(userId)) != null) {
                    state = new ConversationState(identity);
                    state.setAttribute("subject", identity.getSubject());
                } else {
                    log.error((Object)("Not found identity in IdentityRegistry for user " + userId + ", check Login Module."));
                }
                if (state != null) {
                    conversationRegistry.register(stateKey, state);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Register Conversation state " + httpSession.getId()));
                    }
                }
            }
        }
        return state;
    }

    public void destroy() {
    }
}

