/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.ArrayList;
import java.util.List;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.core.TypeDomain;
import org.reflext.core.TypeInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterizedTypeInfoImpl<T, M>
extends TypeInfoImpl<T, M>
implements ParameterizedTypeInfo {
    private final T type;
    private TypeInfo rawType;
    private List<TypeInfo> typeArguments;

    public ParameterizedTypeInfoImpl(TypeDomain<T, M> domain, T type) {
        super(domain);
        this.type = type;
        this.rawType = null;
    }

    public T getType() {
        return this.type;
    }

    public TypeInfo getRawType() {
        if (this.rawType == null) {
            Object rawType = this.domain.typeModel.getRawType(this.type);
            this.rawType = this.domain._getType(rawType);
        }
        return this.rawType;
    }

    public List<TypeInfo> getTypeArguments() {
        if (this.typeArguments == null) {
            ArrayList<TypeInfo> typeArguments = new ArrayList<TypeInfo>();
            for (Object typeArgument : this.domain.typeModel.getTypeArguments(this.type)) {
                TypeInfoImpl ta = this.domain._getType(typeArgument);
                typeArguments.add(ta);
            }
            this.typeArguments = typeArguments;
        }
        return this.typeArguments;
    }

    public TypeInfo getOwnerType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int hashCode = this.getRawType().hashCode();
        for (TypeInfo typeArgument : this.getTypeArguments()) {
            hashCode = hashCode * 43 + typeArgument.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ParameterizedTypeInfo) {
            ParameterizedTypeInfo that = (ParameterizedTypeInfo)obj;
            if (this.getRawType().equals(that.getRawType())) {
                List<TypeInfo> typeArguments = this.getTypeArguments();
                List thatTypeArguments = that.getTypeArguments();
                if (typeArguments.size() == thatTypeArguments.size()) {
                    int length = typeArguments.size();
                    for (int i = 0; i < length; ++i) {
                        TypeInfo thatTypeArgument;
                        TypeInfo typeArgument = typeArguments.get(i);
                        if (typeArgument.equals(thatTypeArgument = (TypeInfo)thatTypeArguments.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ParameterizedType[rawType" + this.getRawType() + ",typeArguments=" + this.getTypeArguments() + "]";
    }
}

