/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.jdbc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CreateDBSchemaPlugin
extends BaseComponentPlugin {
    protected static Log log = ExoLogger.getLogger((String)"jcr.CreateDBSchemaPlugin");
    private String dataSource;
    private String script;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateDBSchemaPlugin(InitParams params) throws ConfigurationException {
        ValueParam dsParam = params.getValueParam("data-source");
        ValueParam scriptFileParam = params.getValueParam("script-file");
        ValueParam scriptParam = params.getValueParam("script");
        if (dsParam == null) {
            return;
        }
        this.dataSource = dsParam.getValue();
        if (scriptParam != null) {
            this.script = scriptParam.getValue();
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(scriptFileParam.getValue());
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(scriptFileParam.getValue());
        }
        if (is == null) {
            try {
                log.warn((Object)("Db script not found as system resource... Trying to search as file by path: " + scriptFileParam.getValue()));
                is = new FileInputStream(scriptFileParam.getValue());
                log.info((Object)("Db script found as file by path: " + scriptFileParam.getValue()));
            }
            catch (IOException e) {
                log.warn((Object)("Db script not found as file by path: " + scriptFileParam.getValue() + ". " + e));
            }
        }
        if (is == null) {
            try {
                log.warn((Object)("Db script not found as system resource... Trying to search as file by url: " + scriptFileParam.getValue()));
                is = new URL(scriptFileParam.getValue()).openStream();
                log.info((Object)("Db script found as file by url: " + scriptFileParam.getValue()));
            }
            catch (IOException e) {
                log.warn((Object)("Db script not found as file by url: " + scriptFileParam.getValue() + ". " + e));
            }
        }
        if (is == null) {
            throw new ConfigurationException("Could not open input stream for db script " + cl.getResource(scriptFileParam.getValue()));
        }
        try {
            byte[] buf = new byte[is.available()];
            is.read(buf);
            this.script = new String(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getScript() {
        return this.script;
    }
}

