/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserProfileImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileEventListenerHandler;
import org.exoplatform.services.organization.UserProfileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfileHandlerImpl
extends CommonHandler
implements UserProfileHandler,
UserProfileEventListenerHandler {
    public static final String JOS_ATTRIBUTES = "jos:attributes";
    protected final List<UserProfileEventListener> listeners = new ArrayList<UserProfileEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.UserProfileHandlerImpl");

    UserProfileHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners.add(listener);
    }

    public UserProfile createUserProfileInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.createUserProfileInstance() method is started");
        }
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.createUserProfileInstance(String) method is started");
        }
        return new UserProfileImpl(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile findUserProfileByName(String userName) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            UserProfile userProfile = this.findUserProfileByName(session, userName);
            return userProfile;
        }
        finally {
            session.logout();
        }
    }

    private UserProfile findUserProfileByName(Session session, String userName) throws Exception {
        UserProfile profile;
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.findUserProfileByName method is started");
        }
        if ((profile = (UserProfile)this.service.getCacheHandler().get((Serializable)((Object)userName), CacheHandler.CacheType.USER_PROFILE)) != null) {
            return profile;
        }
        try {
            profile = this.readUserProfile(session, userName);
            if (profile != null) {
                this.service.getCacheHandler().put((Serializable)((Object)userName), profile, CacheHandler.CacheType.USER_PROFILE);
            }
            return profile;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find '" + userName + "' profile", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findUserProfiles() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findUserProfiles(session);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findUserProfiles(Session session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.findUserProfiles method is started");
        }
        try {
            ArrayList<UserProfile> types = new ArrayList<UserProfile>();
            Node storagePath = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users");
            NodeIterator nodes = storagePath.getNodes();
            while (nodes.hasNext()) {
                UserProfile userProfile = this.readUserProfile(session, nodes.nextNode().getName());
                if (userProfile == null) continue;
                types.add(userProfile);
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find user profiles", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            UserProfile userProfile = this.removeUserProfile(session, userName, broadcast);
            return userProfile;
        }
        finally {
            session.logout();
        }
    }

    private UserProfile removeUserProfile(Session session, String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.removeUserProfile method is started");
        }
        try {
            Node profileNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + userName + "/" + "jos:profile");
            UserProfile userProfile = this.readObjectFromNode(session, profileNode.getNode(JOS_ATTRIBUTES));
            if (broadcast) {
                this.preDelete(userProfile);
            }
            profileNode.remove();
            session.save();
            this.service.getCacheHandler().remove((Serializable)((Object)userName), CacheHandler.CacheType.USER_PROFILE);
            if (broadcast) {
                this.postDelete(userProfile);
            }
            return userProfile;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove '" + userName + "' profile", e);
        }
    }

    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.saveUserProfile(session, profile, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void saveUserProfile(Session session, UserProfile profile, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.saveUserProfile method is started");
        }
        try {
            Node attrNode;
            Node profileNode;
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + profile.getUserName());
            try {
                profileNode = (Node)session.getItem(uNode.getPath() + "/" + "jos:profile");
            }
            catch (PathNotFoundException e) {
                profileNode = uNode.addNode("jos:profile");
            }
            try {
                attrNode = (Node)session.getItem(profileNode.getPath() + "/" + JOS_ATTRIBUTES);
            }
            catch (PathNotFoundException e) {
                attrNode = profileNode.addNode(JOS_ATTRIBUTES);
            }
            if (broadcast) {
                this.preSave(profile, false);
            }
            for (String key : profile.getUserInfoMap().keySet()) {
                attrNode.setProperty(key, profile.getAttribute(key));
            }
            session.save();
            this.service.getCacheHandler().put((Serializable)((Object)profile.getUserName()), profile, CacheHandler.CacheType.USER_PROFILE);
            if (broadcast) {
                this.postSave(profile, false);
            }
        }
        catch (PathNotFoundException e) {
            return;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save '" + profile.getUserName() + "' profile", e);
        }
    }

    private UserProfile readUserProfile(Session session, String userName) throws Exception {
        try {
            Node attrNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + userName + "/" + "jos:profile" + "/" + JOS_ATTRIBUTES);
            return this.readObjectFromNode(session, attrNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read user profile data", e);
        }
    }

    private UserProfile readObjectFromNode(Session session, Node node) throws Exception {
        try {
            UserProfileImpl userProfile = new UserProfileImpl(node.getParent().getParent().getName());
            PropertyIterator props = node.getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (prop.getName().startsWith("jcr:") || prop.getName().startsWith("exo:") || prop.getName().startsWith("jos:")) continue;
                userProfile.setAttribute(prop.getName(), prop.getString());
            }
            return userProfile;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read user profile data from node", e);
        }
    }

    private void preSave(UserProfile userProfile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.preSave(userProfile, isNew);
        }
    }

    private void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.postSave(userProfile, isNew);
        }
    }

    private void preDelete(UserProfile userProfile) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.preDelete(userProfile);
        }
    }

    private void postDelete(UserProfile userProfile) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.postDelete(userProfile);
        }
    }

    public List<UserProfileEventListener> getUserProfileListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

