/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.organization.GroupImpl;
import org.exoplatform.services.jcr.ext.organization.JCROrgServiceHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupEventListenerHandler;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupHandlerImpl
extends JCROrgServiceHandler
implements GroupHandler,
GroupEventListenerHandler {
    protected final List<GroupEventListener> listeners = new ArrayList<GroupEventListener>();

    GroupHandlerImpl(JCROrganizationServiceImpl service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.addChild(session, (GroupImpl)parent, (GroupImpl)child, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void addChild(Session session, GroupImpl parent, GroupImpl child, boolean broadcast) throws Exception {
        Node parentNode = this.utils.getGroupNode(session, parent);
        Node groupNode = parentNode.addNode(child.getGroupName(), "jos:hierarchyGroup-v2");
        String parentId = parent == null ? null : parent.getId();
        child.setParentId(parentId);
        child.setInternalId(groupNode.getUUID());
        if (broadcast) {
            this.preSave(child, true);
        }
        this.writeGroup(child, groupNode);
        session.save();
        this.putInCache(child);
        if (broadcast) {
            this.postSave(child, true);
        }
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    public Group createGroupInstance() {
        return new GroupImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group findGroupById(String groupId) throws Exception {
        Group group = this.getFromCache(groupId);
        if (group != null) {
            return group;
        }
        Session session = this.service.getStorageSession();
        try {
            Node groupNode;
            try {
                groupNode = this.utils.getGroupNode(session, groupId);
            }
            catch (PathNotFoundException e) {
                Group group2 = null;
                session.logout();
                return group2;
            }
            group = this.readGroup(groupNode);
            this.putInCache(group);
        }
        finally {
            session.logout();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        Session session = this.service.getStorageSession();
        try {
            Node userNode;
            try {
                userNode = this.utils.getUserNode(session, userName);
            }
            catch (PathNotFoundException e) {
                ArrayList arrayList = new ArrayList();
                session.logout();
                return arrayList;
            }
            PropertyIterator refUserProps = userNode.getReferences();
            while (refUserProps.hasNext()) {
                Node refUserNode = refUserProps.nextProperty().getParent();
                if (membershipType != null && !refUserNode.hasNode(membershipType)) continue;
                Node groupNode = refUserNode.getParent().getParent();
                groups.add(this.readGroup(groupNode));
            }
        }
        finally {
            session.logout();
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findGroups(Group parent) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findGroups(session, parent, false);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findGroups(Session session, Group parent, boolean recursive) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        String parentId = parent == null ? "" : parent.getId();
        NodeIterator childNodes = this.utils.getGroupNode(session, parentId).getNodes();
        while (childNodes.hasNext()) {
            Node groupNode = childNodes.nextNode();
            if (groupNode.getName().startsWith("jos:memberships")) continue;
            Group group = this.readGroup(groupNode);
            groups.add(group);
            if (!recursive) continue;
            groups.addAll(this.findGroups(session, group, recursive));
        }
        return groups;
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        return this.findGroupByMembership(user, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllGroups() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findGroups(session, null, true);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Group group2 = this.removeGroup(session, group, broadcast);
            return group2;
        }
        finally {
            session.logout();
        }
    }

    private Group removeGroup(Session session, Group group, boolean broadcast) throws Exception {
        if (group == null) {
            throw new OrganizationServiceException("Can not remove group, since it is null");
        }
        Node groupNode = this.utils.getGroupNode(session, group);
        long childrenCount = ((ExtendedNode)groupNode).getNodesLazily(1).getSize() - 1L;
        if (childrenCount > 0L) {
            throw new OrganizationServiceException("Can not remove group till children exist");
        }
        if (broadcast) {
            this.preDelete(group);
        }
        this.removeMemberships(groupNode, broadcast);
        groupNode.remove();
        session.save();
        this.removeFromCache(group.getId());
        this.removeAllRelatedFromCache(group.getId());
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    private void removeMemberships(Node groupNode, boolean broadcast) throws RepositoryException {
        NodeIterator refUsers = groupNode.getNode("jos:memberships").getNodes();
        while (refUsers.hasNext()) {
            refUsers.nextNode().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGroup(Group group, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Node groupNode = this.utils.getGroupNode(session, group);
            if (broadcast) {
                this.preSave(group, false);
            }
            this.writeGroup(group, groupNode);
            session.save();
            this.putInCache(group);
            if (broadcast) {
                this.postSave(group, false);
            }
        }
        finally {
            session.logout();
        }
    }

    void migrateGroup(Node oldGroupNode) throws Exception {
        String groupName = oldGroupNode.getName();
        String desc = this.utils.readString(oldGroupNode, "jos:description");
        String label = this.utils.readString(oldGroupNode, "jos:label");
        String parentId = this.utils.readString(oldGroupNode, "jos:parentId");
        GroupImpl group = new GroupImpl(groupName, parentId);
        group.setDescription(desc);
        group.setLabel(label);
        Group parentGroup = this.findGroupById(group.getParentId());
        if (this.findGroupById(group.getId()) != null) {
            this.removeGroup(group, false);
        }
        this.addChild(parentGroup, group, false);
    }

    private Group readGroup(Node groupNode) throws Exception {
        String groupName = groupNode.getName();
        String desc = this.utils.readString(groupNode, "jos:description");
        String label = this.utils.readString(groupNode, "jos:label");
        String parentId = this.utils.getGroupIds((Node)groupNode).parentId;
        GroupImpl group = new GroupImpl(groupName, parentId);
        group.setInternalId(groupNode.getUUID());
        group.setDescription(desc);
        group.setLabel(label);
        return group;
    }

    private void writeGroup(Group group, Node node) throws OrganizationServiceException {
        try {
            node.setProperty("jos:label", group.getLabel());
            node.setProperty("jos:description", group.getDescription());
        }
        catch (RepositoryException e) {
            throw new OrganizationServiceException("Can not write group properties", e);
        }
    }

    private Group getFromCache(String groupId) {
        return (Group)this.cache.get((Serializable)((Object)groupId), CacheHandler.CacheType.GROUP);
    }

    private void putInCache(Group group) {
        this.cache.put((Serializable)((Object)group.getId()), group, CacheHandler.CacheType.GROUP);
    }

    private void removeFromCache(String groupId) {
        this.cache.remove((Serializable)((Object)groupId), CacheHandler.CacheType.GROUP);
    }

    private void removeAllRelatedFromCache(String groupId) {
        this.cache.remove((Serializable)((Object)("g=" + groupId)), CacheHandler.CacheType.MEMBERSHIP);
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.postDelete(group);
        }
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    public void addGroupEventListener(GroupEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    public List<GroupEventListener> getGroupListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public static class GroupProperties {
        public static final String JOS_DESCRIPTION = "jos:description";
        public static final String JOS_LABEL = "jos:label";
    }
}

