/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.artifact.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.IdentityConstants;

@Path(value="/maven2/")
public class RESTArtifactLoaderService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RESTArtifactLoaderService.class);
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private NodeRepresentationService nodeRepresentationService;
    private String mavenRoot;
    private String repository;
    private String workspace;
    private String realmName;
    private SessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    private static final Comparator<Node> NODE_COMPARATOR = new NodeComparator();

    public RESTArtifactLoaderService(InitParams initParams, SessionProviderService sessionProviderService, RepositoryService repositoryService, NodeRepresentationService nodeRepresentationService, ExoContainerContext context) throws Exception {
        PropertiesParam props = initParams.getPropertiesParam("artifact.workspace");
        if (props == null) {
            throw new IllegalArgumentException("Properties-param 'artifact.workspace' expected.");
        }
        this.nodeRepresentationService = nodeRepresentationService;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.repository = props.getProperty("repository");
        this.workspace = props.getProperty("workspace");
        this.mavenRoot = props.getProperty("mavenRoot");
        if (this.mavenRoot.startsWith("/")) {
            this.mavenRoot = this.mavenRoot.substring(1);
        }
        if (!this.mavenRoot.endsWith("/")) {
            this.mavenRoot = this.mavenRoot + "/";
        }
        this.realmName = context.getRealmName();
    }

    @GET
    @Path(value="/{path:.*}/")
    public Response getResource(@PathParam(value="path") String mavenPath, @Context UriInfo uriInfo, @QueryParam(value="view") String view, @QueryParam(value="gadget") String gadget) {
        Response response;
        String resourcePath = this.mavenRoot + mavenPath;
        String shaResourcePath = mavenPath.endsWith(".sha1") ? this.mavenRoot + mavenPath : this.mavenRoot + mavenPath + ".sha1";
        mavenPath = uriInfo.getBaseUriBuilder().path(this.getClass()).path(mavenPath).build(new Object[0]).toString();
        Session ses = null;
        try {
            SessionProvider sp = this.sessionProviderService.getSessionProvider(null);
            if (sp == null) {
                throw new RepositoryException("Access to JCR Repository denied. SessionProvider is null.");
            }
            ses = sp.getSession(this.workspace, this.repositoryService.getRepository(this.repository));
            ExtendedNode node = (ExtendedNode)ses.getRootNode().getNode(resourcePath);
            if (RESTArtifactLoaderService.isFile((Node)node)) {
                if (view != null && view.equalsIgnoreCase("true")) {
                    ExtendedNode shaNode;
                    block21: {
                        shaNode = null;
                        try {
                            shaNode = (ExtendedNode)ses.getRootNode().getNode(shaResourcePath);
                        }
                        catch (RepositoryException e) {
                            if (!LOG.isTraceEnabled()) break block21;
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        }
                    }
                    Response response2 = this.getArtifactInfo((Node)node, mavenPath, gadget, (Node)shaNode);
                    return response2;
                }
                Response response3 = this.downloadArtifact((Node)node);
                return response3;
            }
            Response response4 = this.browseRepository((Node)node, mavenPath, gadget);
            return response4;
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            return response;
        }
        catch (AccessDeniedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (ses == null || ses.getUserID().equals(IdentityConstants.ANONIM)) {
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)("Basic realm=\"" + this.realmName + "\"")).build();
                return response;
            }
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            return response;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed get maven artifact", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    public Response getRootNodeList(@Context UriInfo uriInfo, @QueryParam(value="view") String view, @QueryParam(value="gadget") String gadget) {
        return this.getResource("", uriInfo, view, gadget);
    }

    private static boolean isFile(Node node) throws RepositoryException {
        if (!node.isNodeType("nt:file")) {
            return false;
        }
        return node.getNode("jcr:content").isNodeType("nt:resource");
    }

    private Response browseRepository(final Node node, final String mavenPath, final String gadget) throws IOException {
        final PipedOutputStream po = new PipedOutputStream();
        PipedInputStream pi = new PipedInputStream(po);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    XMLOutputFactory factory = XMLOutputFactory.newInstance();
                    factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
                    XMLStreamWriter xsw = factory.createXMLStreamWriter(po, "UTF-8");
                    xsw.writeStartDocument("UTF-8", "1.0");
                    xsw.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
                    xsw.writeCharacters("\n");
                    if (gadget == null || !gadget.equalsIgnoreCase("true")) {
                        xsw.writeStartElement("html");
                        xsw.writeDefaultNamespace(RESTArtifactLoaderService.XHTML_NS);
                        xsw.writeStartElement("head");
                        xsw.writeStartElement("style");
                        xsw.writeAttribute("type", "text/css");
                        xsw.writeCharacters("a {text-decoration: none; color: #10409C; }a:hover {text-decoration: underline;}.centered { text-align: center; }.underlined { border-bottom : 1px solid #cccccc;  font-weight: bold;  text-align: center; }\n");
                        xsw.writeEndElement();
                        xsw.writeStartElement("title");
                        xsw.writeCharacters("Maven2 Repository Browser");
                        xsw.writeEndElement();
                        xsw.writeEndElement();
                    }
                    xsw.writeStartElement("body");
                    xsw.writeStartElement("h2");
                    xsw.writeAttribute("class", "centered");
                    xsw.writeCharacters("Maven2 Repository");
                    xsw.writeEndElement();
                    xsw.writeStartElement("table");
                    xsw.writeAttribute("width", "90%");
                    xsw.writeAttribute("style", "table-layout:fixed;");
                    xsw.writeStartElement("tr");
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeAttribute("width", "7%");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeCharacters("name");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeAttribute("width", "18%");
                    xsw.writeCharacters("media-type");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeAttribute("width", "15%");
                    xsw.writeCharacters("size");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeAttribute("width", "18%");
                    xsw.writeCharacters("last modified");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    String parent = mavenPath.substring(0, mavenPath.lastIndexOf(47));
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "parenticon");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeStartElement("a");
                    xsw.writeAttribute("href", parent + "?view=true&gadget=" + gadget);
                    xsw.writeCharacters("..");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeEmptyElement("td");
                    xsw.writeEmptyElement("td");
                    xsw.writeEmptyElement("td");
                    EntityCollection nodes = (EntityCollection)node.getNodes();
                    Collections.sort(nodes.getList(), NODE_COMPARATOR);
                    while (nodes.hasNext()) {
                        Node node2 = nodes.nextNode();
                        xsw.writeStartElement("tr");
                        if (RESTArtifactLoaderService.isFile(node2)) {
                            if (node2.getName().endsWith("sha1")) continue;
                            NodeRepresentation nodeRepresentation = RESTArtifactLoaderService.this.nodeRepresentationService.getNodeRepresentation(node2, null);
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "fileicon");
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("style", "font-style: italic;");
                            xsw.writeStartElement("a");
                            xsw.writeAttribute("href", (mavenPath.endsWith("/") ? mavenPath + node2.getName() : mavenPath + "/" + node2.getName()) + "?view=true&gadget=" + gadget);
                            xsw.writeCharacters(node2.getName());
                            xsw.writeEndElement();
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters(nodeRepresentation.getMediaType());
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters("" + nodeRepresentation.getContentLenght());
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters(new Date(nodeRepresentation.getLastModified()).toString());
                            xsw.writeEndElement();
                        } else {
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "foldericon");
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeStartElement("a");
                            xsw.writeAttribute("href", (mavenPath.endsWith("/") ? mavenPath + node2.getName() : mavenPath + "/" + node2.getName()) + "?view=true&gadget=" + gadget);
                            xsw.writeCharacters(node2.getName());
                            xsw.writeEndElement();
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters("-");
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters("-");
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters("-");
                            xsw.writeEndElement();
                        }
                        xsw.writeEndElement();
                    }
                    xsw.writeStartElement("tr");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    if (gadget == null || !gadget.equalsIgnoreCase("true")) {
                        xsw.writeEndElement();
                    }
                    xsw.writeEndDocument();
                }
                catch (XMLStreamException xmle) {
                    LOG.error((Object)xmle.getLocalizedMessage(), (Throwable)xmle);
                }
                catch (RepositoryException re) {
                    LOG.error((Object)re.getLocalizedMessage(), (Throwable)re);
                }
                finally {
                    try {
                        po.flush();
                        po.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }.start();
        return Response.ok((Object)pi, (String)"text/html").build();
    }

    private Response downloadArtifact(Node node) throws Exception {
        NodeRepresentation nodeRepresentation = this.nodeRepresentationService.getNodeRepresentation(node, null);
        if (node.canAddMixin("exo:mavencounter")) {
            node.addMixin("exo:mavencounter");
            node.getSession().save();
        }
        node.setProperty("exo:downloadcounter", node.getProperty("exo:downloadcounter").getLong() + 1L);
        node.getSession().save();
        long lastModified = nodeRepresentation.getLastModified();
        String contentType = nodeRepresentation.getMediaType();
        long contentLength = nodeRepresentation.getContentLenght();
        InputStream entity = nodeRepresentation.getInputStream();
        Response response = Response.ok((Object)entity, (String)contentType).header("Content-Length", (Object)Long.toString(contentLength)).lastModified(new Date(lastModified)).build();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getArtifactInfo(Node node, String mavenPath, String gadget, Node shaNode) throws Exception {
        NodeRepresentation nodeRepresentation = this.nodeRepresentationService.getNodeRepresentation(node, null);
        NodeRepresentation shNodeRepresentation = null;
        if (shaNode != null) {
            shNodeRepresentation = this.nodeRepresentationService.getNodeRepresentation(shaNode, null);
        }
        PipedOutputStream po = new PipedOutputStream();
        PipedInputStream pi = new PipedInputStream(po);
        long lastModified = nodeRepresentation.getLastModified();
        long contentLength = nodeRepresentation.getContentLenght();
        try {
            if (node.canAddMixin("exo:mavencounter")) {
                node.addMixin("exo:mavencounter");
                node.getSession().save();
            }
            int count = (int)node.getProperty("exo:downloadcounter").getLong();
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = factory.createXMLStreamWriter(po, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            xsw.writeCharacters("\n");
            xsw.writeStartElement("html");
            xsw.writeDefaultNamespace(XHTML_NS);
            xsw.writeStartElement("head");
            xsw.writeStartElement("style");
            xsw.writeAttribute("type", "text/css");
            xsw.writeCharacters("a {text-decoration: none; color: #10409C;}a:hover {text-decoration: underline;}.centered { text-align: center; }.underlined { border-bottom : 1px solid #cccccc; }\n");
            xsw.writeEndElement();
            xsw.writeStartElement("title");
            xsw.writeCharacters("Maven2 Artifact Information");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("body");
            xsw.writeStartElement("b");
            xsw.writeCharacters("Artifact Information :");
            xsw.writeEndElement();
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Name:  " + node.getName());
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Size:  " + contentLength);
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Last modified:  " + new Date(lastModified).toString());
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Download:  ");
            xsw.writeStartElement("a");
            xsw.writeAttribute("href", mavenPath.endsWith("/") ? mavenPath.substring(0, mavenPath.length() - 1) : mavenPath);
            xsw.writeCharacters("Link");
            xsw.writeEndElement();
            if (shNodeRepresentation != null) {
                xsw.writeEmptyElement("br");
                xsw.writeCharacters("Checksum:  " + this.getStreamAsString(shNodeRepresentation.getInputStream()));
                xsw.writeEmptyElement("br");
            }
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Downloads count :  " + count);
            xsw.writeEmptyElement("br");
            xsw.writeEmptyElement("br");
            xsw.writeStartElement("a");
            xsw.writeAttribute("href", (mavenPath.endsWith("/") ? mavenPath.substring(0, mavenPath.length() - 1).substring(0, mavenPath.lastIndexOf("/")) : mavenPath.substring(0, mavenPath.lastIndexOf("/"))) + "?view=true&gadget=" + gadget);
            xsw.writeCharacters("Back to browsing");
            xsw.writeEndElement();
            xsw.writeEmptyElement("br");
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            LOG.error((Object)xmle.getLocalizedMessage(), (Throwable)xmle);
        }
        catch (RepositoryException re) {
            LOG.error((Object)re.getLocalizedMessage(), (Throwable)re);
        }
        finally {
            try {
                po.flush();
                po.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Response.ok((Object)pi, (String)"text/html").build();
    }

    protected String getStreamAsString(InputStream stream) throws IOException {
        byte[] buff = new byte[stream.available()];
        stream.read(buff);
        return new String(buff);
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                if (RESTArtifactLoaderService.isFile(o1) && !RESTArtifactLoaderService.isFile(o2)) {
                    return 1;
                }
                if (!RESTArtifactLoaderService.isFile(o1) && RESTArtifactLoaderService.isFile(o2)) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
            catch (RepositoryException e) {
                LOG.error((Object)"", (Throwable)e);
                return 0;
            }
        }
    }
}

