/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.Date;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.organization.Group;

public class Utils {
    private JCROrganizationServiceImpl service;

    Utils(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    Date readDate(Node node, String propertyName) throws OrganizationServiceException {
        try {
            return node.getProperty(propertyName).getDate().getTime();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (ValueFormatException e) {
            throw new OrganizationServiceException("Property " + propertyName + " contains wrong value format", e);
        }
        catch (RepositoryException e) {
            throw new OrganizationServiceException("Can not read property " + propertyName, e);
        }
    }

    String readString(Node node, String propertyName) throws OrganizationServiceException {
        try {
            return node.getProperty(propertyName).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (ValueFormatException e) {
            throw new OrganizationServiceException("Property " + propertyName + " contains wrong value format", e);
        }
        catch (RepositoryException e) {
            throw new OrganizationServiceException("Can not read property " + propertyName, e);
        }
    }

    String composeMembershipId(Node groupNode, Node refUserNode, Node refTypeNode) throws RepositoryException {
        return groupNode.getUUID() + ',' + refUserNode.getName() + ',' + (refTypeNode.getName().equals("jos:membershipTypeAny") ? "*" : refTypeNode.getName());
    }

    Node getUsersStorageNode(Session session) throws PathNotFoundException, RepositoryException {
        return (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users");
    }

    Node getMembershipTypeStorageNode(Session session) throws PathNotFoundException, RepositoryException {
        return (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:membershipTypes");
    }

    Node getUserNode(Session session, String userName) throws PathNotFoundException, RepositoryException {
        return (Node)session.getItem(this.getUserNodePath(userName));
    }

    String getUserNodePath(String userName) throws RepositoryException {
        return this.service.getStoragePath() + "/" + "jos:users" + "/" + userName;
    }

    Node getMembershipTypeNode(Session session, String name) throws PathNotFoundException, RepositoryException {
        return (Node)session.getItem(this.getMembershipTypeNodePath(name));
    }

    Node getProfileNode(Session session, String userName) throws PathNotFoundException, RepositoryException {
        return (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:users" + "/" + userName + "/" + "jos:profile");
    }

    Node getGroupNode(Session session, Group group) throws PathNotFoundException, RepositoryException {
        return this.getGroupNode(session, group == null ? "" : group.getId());
    }

    Node getGroupNode(Session session, String groupId) throws PathNotFoundException, RepositoryException {
        return (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:groups" + groupId);
    }

    String getGroupStoragePath() throws RepositoryException {
        return this.service.getStoragePath() + "/" + "jos:groups";
    }

    String getMembershipTypeNodePath(String name) throws RepositoryException {
        return this.service.getStoragePath() + "/" + "jos:membershipTypes" + "/" + (name.equals("*") ? "jos:membershipTypeAny" : name);
    }

    GroupIds getGroupIds(Node groupNode) throws RepositoryException {
        String storagePath = this.getGroupStoragePath();
        String nodePath = groupNode.getPath();
        String groupId = nodePath.substring(storagePath.length());
        String parentId = groupId.substring(0, groupId.lastIndexOf("/"));
        return new GroupIds(groupId, parentId);
    }

    IdComponents splitId(String id) throws IndexOutOfBoundsException {
        String[] membershipIDs = id.split(",");
        String groupNodeId = membershipIDs[0];
        String userName = membershipIDs[1];
        String type = membershipIDs[2];
        return new IdComponents(groupNodeId, userName, type);
    }

    class GroupIds {
        final String groupId;
        final String parentId;

        private GroupIds(String groupId, String parentId) {
            this.groupId = groupId;
            this.parentId = parentId;
        }
    }

    class IdComponents {
        final String groupNodeId;
        final String userName;
        final String type;

        private IdComponents(String groupNodeId, String userName, String type) {
            this.groupNodeId = groupNodeId;
            this.userName = userName;
            this.type = type;
        }
    }
}

