/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.index.persistent.filter;

import java.util.Set;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.ext.index.persistent.api.JCRIndexingService;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.DefaultChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.LocalIndexMarker;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;

public class PersistentIndexChangesFilter
extends DefaultChangesFilter
implements LocalIndexMarker {
    private JCRIndexingService jcrIndexingQueueService;

    public PersistentIndexChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws Exception {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm, false);
        this.getJcrIndexingQueueService().init(handler, config);
        super.init();
    }

    protected void doUpdateIndex(Set<String> removedNodes, Set<String> addedNodes, Set<String> parentRemovedNodes, Set<String> parentAddedNodes) {
        try {
            this.getJcrIndexingQueueService().processIndexingQueue();
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while indexing from queue before applying Index changes", e);
        }
        super.doUpdateIndex(removedNodes, addedNodes, parentRemovedNodes, parentAddedNodes);
        this.getJcrIndexingQueueService().applyIndexChangesOnQueue(removedNodes, addedNodes, parentRemovedNodes, parentAddedNodes, this.getSearchManager().getWsId());
    }

    protected void doUpdateIndex(ChangesFilterListsWrapper changes) {
        try {
            this.getJcrIndexingQueueService().processIndexingQueue();
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while indexing from queue before applying Index changes", e);
        }
        super.doUpdateIndex(changes);
        this.getJcrIndexingQueueService().applyIndexChangesOnQueue(changes, this.getSearchManager().getWsId());
    }

    private JCRIndexingService getJcrIndexingQueueService() {
        if (this.jcrIndexingQueueService == null) {
            this.jcrIndexingQueueService = (JCRIndexingService)CommonsUtils.getService(JCRIndexingService.class);
        }
        return this.jcrIndexingQueueService;
    }
}

