/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditRecord;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.ext.audit.AuditServiceImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionCatalog;
import org.exoplatform.services.security.IdentityConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuditServiceTest
extends BaseStandaloneTest {
    public static final String ROOT_PATH = "AuditServiceTest";
    protected AuditService service;
    protected SessionActionCatalog catalog;
    protected Session exo1Session;
    protected Session exo2Session;
    protected Session adminSession;
    protected NodeImpl auditServiceTestRoot;
    protected Session exo2AdminSession;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.service = (AuditService)this.container.getComponentInstanceOfType(AuditService.class);
        this.catalog = (SessionActionCatalog)this.session.getContainer().getComponentInstanceOfType(SessionActionCatalog.class);
        this.exo1Session = this.repository.login((Credentials)new SimpleCredentials("marry", "exo".toCharArray()));
        this.exo2AdminSession = this.repository.login((Credentials)new SimpleCredentials("john", "exo".toCharArray()));
        this.adminSession = this.repository.login((Credentials)new SimpleCredentials("root", "exo".toCharArray()));
        this.exo2Session = this.repository.login((Credentials)new SimpleCredentials("demo", "exo".toCharArray()));
        NodeImpl rootAdmin = (NodeImpl)this.adminSession.getRootNode();
        this.auditServiceTestRoot = (NodeImpl)rootAdmin.addNode(ROOT_PATH);
        this.auditServiceTestRoot.addMixin("exo:privilegeable");
        this.auditServiceTestRoot.setPermission(IdentityConstants.ANY, PermissionType.ALL);
        rootAdmin.save();
        this.auditServiceTestRoot = (NodeImpl)this.root.getNode(ROOT_PATH);
    }

    public void testAddAuditHistoryAction() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("deep");
        this.session.save();
        String auditHistoryUUID = node.getProperty("exo:auditHistory").getString();
        Node auditHistory = this.session.getNodeByUUID(auditHistoryUUID);
        AuditServiceTest.assertTrue((boolean)auditHistory.isNodeType("exo:auditHistory"));
        AuditServiceTest.assertEquals((String)auditHistory.getProperty("exo:targetNode").getString(), (String)node.getUUID());
        AuditServiceTest.assertEquals((String)"1", (String)auditHistory.getProperty("exo:lastRecord").getString());
        AuditServiceTest.assertEquals((long)1L, (long)auditHistory.getNodes().getSize());
        this.session.save();
        this.service.removeHistory((Node)node);
        node.remove();
        this.session.save();
        try {
            this.session.getNodeByUUID(auditHistoryUUID);
            AuditServiceTest.fail((String)"History should be removed");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testAddAuditHistoryMixinAction() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("mixin", "nt:unstructured");
        node.addMixin("exo:auditable");
        String auditHistoryUUID = node.getProperty("exo:auditHistory").getString();
        Node auditHistory = this.session.getNodeByUUID(auditHistoryUUID);
        node.setProperty("test", "testValue");
        AuditServiceTest.assertTrue((boolean)auditHistory.isNodeType("exo:auditHistory"));
        AuditServiceTest.assertEquals((String)auditHistory.getProperty("exo:targetNode").getString(), (String)node.getUUID());
        AuditServiceTest.assertEquals((String)"2", (String)auditHistory.getProperty("exo:lastRecord").getString());
        AuditServiceTest.assertEquals((long)2L, (long)auditHistory.getNodes().getSize());
        this.session.save();
        this.service.removeHistory((Node)node);
        node.remove();
        this.session.save();
        try {
            this.session.getNodeByUUID(auditHistoryUUID);
            AuditServiceTest.fail((String)"History should be removed");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testAddInfoToAuditStorage() throws RepositoryException {
        ExtendedNode node = null;
        try {
            node = (ExtendedNode)this.session.getRootNode().getNode(ROOT_PATH).addNode("testaudit");
            node.addMixin("exo:auditable");
            if (!this.service.hasHistory((Node)node)) {
                this.service.createHistory((Node)node);
            }
            this.session.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            AuditServiceTest.fail((String)("Fail to init AuditStorage" + e.getLocalizedMessage()));
        }
        Property property1 = node.setProperty("property1", "value1");
        this.service.addRecord(null, (Item)node, 1);
        this.service.addRecord(null, (Item)property1, 4);
        Node auditHistory = this.session.getNodeByUUID(node.getProperty("exo:auditHistory").getString());
        AuditServiceTest.assertNotNull((Object)auditHistory);
        AuditServiceTest.assertEquals((long)2L, (long)auditHistory.getNodes().getSize());
        AuditServiceTest.assertTrue((boolean)this.service.hasHistory((Node)node));
        AuditServiceTest.assertNotNull((Object)this.service.getHistory((Node)node));
    }

    public void testChangeSingleValueProperty() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("deep", "nt:unstructured");
        node.setProperty("test", "testValue1");
        node.setProperty("test", "testValue2");
        this.session.save();
        AuditHistory history = this.service.getHistory((Node)node);
        AuditServiceTest.assertEquals((int)3, (int)history.getAuditRecords().size());
        AuditServiceTest.assertEquals((String)"testValue1", (String)((AuditRecord)history.getAuditRecords().get(1)).getNewValues()[0].getString());
        Value[] oldValues = ((AuditRecord)history.getAuditRecords().get(1)).getOldValues();
        AuditServiceTest.assertEquals(null, (Object)oldValues);
        AuditServiceTest.assertEquals((String)"Property is changed", (String)((AuditRecord)history.getAuditRecords().get(2)).getEventTypeName());
        AuditServiceTest.assertEquals((String)"testValue1", (String)((AuditRecord)history.getAuditRecords().get(2)).getOldValues()[0].getString());
        AuditServiceTest.assertEquals((String)"testValue2", (String)((AuditRecord)history.getAuditRecords().get(2)).getNewValues()[0].getString());
    }

    public void testChangeMultiValueProperty() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("deep", "nt:unstructured");
        node.setProperty("test", new String[]{"testValue11", "testValue12"});
        node.setProperty("test", new String[]{"testValue21", "testValue22", "testValue23"});
        this.session.save();
        AuditHistory history = this.service.getHistory((Node)node);
        AuditServiceTest.assertEquals((int)3, (int)history.getAuditRecords().size());
        AuditServiceTest.assertEquals((String)"Property is changed", (String)((AuditRecord)history.getAuditRecords().get(2)).getEventTypeName());
        Value[] oldValues = ((AuditRecord)history.getAuditRecords().get(2)).getOldValues();
        AuditServiceTest.assertEquals((String)"testValue11", (String)oldValues[0].getString());
        AuditServiceTest.assertEquals((String)"testValue12", (String)oldValues[1].getString());
        Value[] newValues = ((AuditRecord)history.getAuditRecords().get(2)).getNewValues();
        AuditServiceTest.assertEquals((String)"testValue21", (String)newValues[0].getString());
        AuditServiceTest.assertEquals((String)"testValue22", (String)newValues[1].getString());
        AuditServiceTest.assertEquals((String)"testValue23", (String)newValues[2].getString());
    }

    public void testChangeBLOBValueProperty() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("deep", "nt:unstructured");
        node.setProperty("test", (InputStream)new StringBufferInputStream("testValue1"));
        node.setProperty("test", (InputStream)new StringBufferInputStream("testValue2"));
        this.session.save();
        AuditHistory history = this.service.getHistory((Node)node);
        AuditServiceTest.assertEquals((String)"Property is changed", (String)((AuditRecord)history.getAuditRecords().get(2)).getEventTypeName());
        Value[] oldValues = ((AuditRecord)history.getAuditRecords().get(2)).getOldValues();
        AuditServiceTest.assertEquals(null, (Object)oldValues);
        Value[] newValues = ((AuditRecord)history.getAuditRecords().get(2)).getNewValues();
        AuditServiceTest.assertEquals(null, (Object)newValues);
    }

    public void testAuditHistory() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("deep", "nt:unstructured");
        String auditHistoryUUID = node.getProperty("exo:auditHistory").getString();
        Node auditHistory = this.session.getNodeByUUID(auditHistoryUUID);
        node.setProperty("test", "testValue");
        AuditServiceTest.assertTrue((boolean)auditHistory.isNodeType("exo:auditHistory"));
        node.getProperty("test").remove();
        this.session.save();
        AuditServiceTest.assertTrue((boolean)this.service.hasHistory((Node)node));
        AuditServiceTest.assertFalse((boolean)this.service.hasHistory(this.session.getRootNode()));
        AuditHistory history = this.service.getHistory((Node)node);
        AuditServiceTest.assertTrue((boolean)node.isSame((Item)history.getAuditableNode()));
        AuditServiceTest.assertEquals((int)3, (int)history.getAuditRecords().size());
        AuditServiceTest.assertEquals((int)4, (int)((AuditRecord)history.getAuditRecords().get(1)).getEventType());
        AuditServiceTest.assertEquals((String)"Property is added", (String)((AuditRecord)history.getAuditRecords().get(1)).getEventTypeName());
        AuditServiceTest.assertEquals((Object)new InternalQName(null, "test"), (Object)((AuditRecord)history.getAuditRecords().get(1)).getPropertyName());
        AuditServiceTest.assertEquals((int)8, (int)((AuditRecord)history.getAuditRecords().get(2)).getEventType());
        AuditServiceTest.assertEquals((String)"Property is removed", (String)((AuditRecord)history.getAuditRecords().get(2)).getEventTypeName());
        this.session.save();
    }

    public void testCheckPermissions() throws Exception {
        Node auditStorage32;
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("testAuditHistory", "nt:unstructured");
        node.addMixin("exo:auditable");
        if (!this.service.hasHistory((Node)node)) {
            this.service.createHistory((Node)node);
        }
        this.session.save();
        this.service.addRecord(null, (Item)node, 1);
        this.session.save();
        NodeImpl rootNode1 = (NodeImpl)this.exo1Session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node1 = (ExtendedNode)rootNode1.addNode("testAuditHistory", "nt:unstructured");
        node1.addMixin("exo:auditable");
        if (!this.service.hasHistory((Node)node1)) {
            this.service.createHistory((Node)node1);
        }
        this.exo1Session.save();
        this.service.addRecord(null, (Item)node1, 1);
        this.exo1Session.save();
        try {
            NodeImpl rootNode2 = (NodeImpl)this.exo2Session.getRootNode().getNode(ROOT_PATH);
            ExtendedNode node2 = (ExtendedNode)rootNode2.getNode("testAuditHistory");
            this.service.removeHistory((Node)node2);
            this.exo2Session.save();
            AuditServiceTest.fail();
        }
        catch (AccessDeniedException rootNode2) {
            // empty catch block
        }
        try {
            this.service.removeHistory((Node)node1);
            this.exo1Session.save();
        }
        catch (AccessDeniedException e) {
            AuditServiceTest.fail();
        }
        Node auditStorage = this.adminSession.getNodeByUUID("00exo0jcr0audit0storage0id000000");
        NodeIterator nIterator = auditStorage.getNodes();
        while (nIterator.hasNext()) {
            nIterator.nextNode();
        }
        Node adminTestAuditHistoryNode = this.adminSession.getRootNode().getNode(ROOT_PATH).getNode("testAuditHistory");
        AuditServiceTest.assertTrue((boolean)this.service.hasHistory(adminTestAuditHistoryNode));
        this.service.removeHistory(adminTestAuditHistoryNode);
        this.adminSession.save();
        Node auditStorage2 = this.exo2AdminSession.getNodeByUUID("00exo0jcr0audit0storage0id000000");
        NodeIterator nIterator2 = auditStorage2.getNodes();
        while (nIterator2.hasNext()) {
            nIterator2.nextNode();
        }
        try {
            auditStorage32 = this.exo1Session.getNodeByUUID("00exo0jcr0audit0storage0id000000");
            auditStorage32.remove();
            this.exo1Session.save();
            AuditServiceTest.fail();
        }
        catch (AccessDeniedException auditStorage32) {
            // empty catch block
        }
        try {
            auditStorage32 = this.exo2AdminSession.getNodeByUUID("00exo0jcr0audit0storage0id000000");
            auditStorage32.remove();
            this.exo2AdminSession.save();
        }
        catch (AccessDeniedException e) {
            AuditServiceTest.fail();
        }
    }

    public void testCreateAndRemoveStorage() throws RepositoryException {
        ExtendedNode node = null;
        try {
            node = (ExtendedNode)this.session.getRootNode().getNode(ROOT_PATH).addNode("teststotage");
            node.addMixin("exo:auditable");
            if (!this.service.hasHistory((Node)node)) {
                this.service.createHistory((Node)node);
            }
            this.session.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            AuditServiceTest.fail((String)("Fail to init AuditStorage" + e.getLocalizedMessage()));
        }
        Node auditHistory = this.session.getNodeByUUID(node.getProperty("exo:auditHistory").getString());
        AuditServiceTest.assertNotNull((String)"Audit history does'n created correctly", (Object)auditHistory);
    }

    public void testIfAuditServiceConfigured() throws Exception {
        AuditServiceTest.assertNotNull((Object)this.container.getComponentInstanceOfType(AuditService.class));
        AuditServiceTest.assertNotNull((Object)this.repository.getNodeTypeManager().getNodeType("exo:auditable"));
        AuditServiceTest.assertNotNull((Object)this.repository.getNodeTypeManager().getNodeType("exo:auditRecord"));
        AuditServiceTest.assertNotNull((Object)this.repository.getNodeTypeManager().getNodeType("exo:auditHistory"));
        AuditServiceTest.assertNotNull((Object)this.repository.getNodeTypeManager().getNodeType("exo:auditStorage"));
    }

    public void testIfAuditStorageCreated() {
        AuditService service = (AuditService)this.container.getComponentInstanceOfType(AuditService.class);
        ExtendedNode node = null;
        try {
            node = (ExtendedNode)this.adminSession.getRootNode().getNode(ROOT_PATH).addNode("auditablenode");
            node.addMixin("exo:auditable");
        }
        catch (RepositoryException e) {
            AuditServiceTest.fail((String)"Fail to add node or add mixin");
        }
        try {
            service.createHistory(node);
            this.adminSession.save();
            AuditServiceTest.assertNotNull((Object)this.adminSession.getNodeByUUID("00exo0jcr0audit0storage0id000000"));
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            AuditServiceTest.fail((String)("Fail to create AUDIT_STORAGE " + e.getLocalizedMessage()));
        }
        try {
            AuditServiceTest.assertNotNull((Object)this.adminSession.getNodeByUUID(node.getProperty("exo:auditHistory").getString()));
        }
        catch (RepositoryException e) {
            AuditServiceTest.fail((String)"Fail to create AUDITHISTORY");
        }
    }

    public void testReadHistory() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("testReadHistory", "nt:unstructured");
        node.addMixin("exo:auditable");
        if (!this.service.hasHistory((Node)node)) {
            this.service.createHistory((Node)node);
        }
        this.session.save();
        this.service.addRecord(null, (Item)node, 1);
        this.session.save();
        this.service.getHistory((Node)node).getAuditRecords();
        Node node2 = this.exo1Session.getRootNode().getNode(ROOT_PATH).getNode("testReadHistory");
        this.service.getHistory(node2).getAuditRecords();
    }

    public void testRemoveAuditable() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.adminSession.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("deep", "nt:unstructured");
        this.adminSession.save();
        AuditServiceTest.assertTrue((boolean)node.isNodeType("exo:auditable"));
        String history = node.getProperty("exo:auditHistory").getString();
        AuditServiceTest.assertNotNull((Object)this.session.getNodeByUUID(history));
        node.remove();
        this.adminSession.save();
        try {
            this.adminSession.getNodeByUUID(history);
            AuditServiceTest.fail((String)"History doesn't removed");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testRemovePropertyAudit() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("deep", "nt:unstructured");
        String auditHistoryUUID = node.getProperty("exo:auditHistory").getString();
        Node auditHistory = this.session.getNodeByUUID(auditHistoryUUID);
        node.setProperty("test", "testValue");
        AuditServiceTest.assertTrue((boolean)auditHistory.isNodeType("exo:auditHistory"));
        node.getProperty("test").remove();
        AuditServiceTest.assertEquals((String)auditHistory.getProperty("exo:targetNode").getString(), (String)node.getUUID());
        AuditServiceTest.assertEquals((String)"3", (String)auditHistory.getProperty("exo:lastRecord").getString());
        AuditServiceTest.assertEquals((long)3L, (long)auditHistory.getNodes().getSize());
        this.session.save();
        this.service.removeHistory((Node)node);
        node.remove();
        this.session.save();
        try {
            this.session.getNodeByUUID(auditHistoryUUID);
            AuditServiceTest.fail((String)"History should be removed");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testDeepAddAuditable() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("deep");
        ExtendedNode childNode = (ExtendedNode)node.addNode("testDeepAddAuditableChild");
        this.session.save();
        AuditServiceTest.assertTrue((boolean)node.isNodeType(AuditService.EXO_AUDITABLE));
        AuditServiceTest.assertTrue((boolean)childNode.isNodeType(AuditService.EXO_AUDITABLE));
        AuditServiceTest.assertTrue((boolean)this.service.hasHistory((Node)node));
        AuditServiceTest.assertTrue((boolean)this.service.hasHistory((Node)childNode));
        node.remove();
        this.session.save();
    }

    public void testNotDeepAddAuditable() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("notdeep");
        ExtendedNode childNode = (ExtendedNode)node.addNode("testNotDeepAddAuditableChild");
        ExtendedNode childNode2 = (ExtendedNode)childNode.addNode("testNotDeepAddAuditableChild2");
        this.session.save();
        AuditServiceTest.assertTrue((boolean)node.isNodeType(AuditService.EXO_AUDITABLE));
        AuditServiceTest.assertTrue((boolean)childNode.isNodeType(AuditService.EXO_AUDITABLE));
        AuditServiceTest.assertFalse((boolean)childNode2.isNodeType(AuditService.EXO_AUDITABLE));
        AuditServiceTest.assertTrue((boolean)this.service.hasHistory((Node)node));
        AuditServiceTest.assertTrue((boolean)this.service.hasHistory((Node)childNode));
        AuditServiceTest.assertFalse((boolean)this.service.hasHistory((Node)childNode2));
        node.remove();
        this.session.save();
    }

    public void testAddAuditWithExistingNode() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH);
        ExtendedNode node = (ExtendedNode)rootNode.addNode("test_add_audit_existing_node", "nt:unstructured");
        node.addMixin("exo:auditable");
        this.service.createHistory((Node)node);
        this.session.save();
        String auditHistoryUUID = node.getProperty("exo:auditHistory").getString();
        Node auditHistory = this.session.getNodeByUUID(auditHistoryUUID);
        AuditServiceTest.assertTrue((boolean)auditHistory.isNodeType("exo:auditHistory"));
        AuditServiceTest.assertEquals((String)auditHistory.getProperty("exo:targetNode").getString(), (String)node.getUUID());
        this.session.save();
        this.service.removeHistory((Node)node);
        node.remove();
        this.session.save();
    }

    public void testSetPropertyAfterAddAudit() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH).addNode("SetPropertyAfterAddAudit");
        this.session.save();
        Node folder = rootNode.addNode("folder", "nt:folder");
        Node subfile = folder.addNode("subfile", "nt:file");
        Node contentNodeOfSubFile = subfile.addNode("jcr:content", "nt:resource");
        contentNodeOfSubFile.setProperty("jcr:lastModified", Calendar.getInstance());
        contentNodeOfSubFile.setProperty("jcr:mimeType", "text/xml");
        contentNodeOfSubFile.setProperty("jcr:data", "");
        subfile.addMixin("exo:auditable");
        if (!this.service.hasHistory(subfile)) {
            this.service.createHistory(subfile);
        }
        folder.getSession().save();
        subfile.addMixin("mix:versionable");
        subfile.addMixin("publication:publication");
        subfile.setProperty("publication:lifecycleName", "Authoring publication");
        subfile.setProperty("publication:currentState", "enrolled");
        ArrayList history = new ArrayList();
        subfile.setProperty("publication:history", history.toArray(new Value[history.size()]));
        folder.getSession().save();
    }

    public void testSetPropertyAfterAddAudit2() throws Exception {
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode().getNode(ROOT_PATH).addNode("SetPropertyAfterAddAudit");
        this.session.save();
        Node filePlan = this.addNodeFilePlan("fileplan", (Node)rootNode, "cateIdentify1", "disposition1", true, true, "mediaType1", "markingList1", "original1", true, false, "trigger1", false, false, false, false, "hourly");
        Node file1 = filePlan.addNode("file1", "nt:file");
        Node contentNode = file1.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        contentNode.setProperty("jcr:mimeType", "text/xml");
        contentNode.setProperty("jcr:data", "");
        file1.getSession().save();
        file1.addMixin("exo:auditable");
        if (!this.service.hasHistory(file1)) {
            this.service.createHistory(file1);
        }
        filePlan.getSession().save();
        file1.addMixin("mix:versionable");
        file1.addMixin("publication:publication");
        file1.setProperty("publication:lifecycleName", "Authoring publication");
        file1.setProperty("publication:currentState", "enrolled");
        ArrayList history = new ArrayList();
        file1.setProperty("publication:history", history.toArray(new Value[history.size()]));
        filePlan.getSession().save();
    }

    private Node addNodeFilePlan(String nodeName, Node parent, String cateIdentify, String disposition, boolean permanentRecord, boolean recordFolder, String mediaType, String markingList, String original, boolean recordIndicator, boolean cutoff, String eventTrigger, boolean processHold, boolean processTransfer, boolean processAccession, boolean processDestruction, String vitalRecordReview) throws Exception {
        Node filePlan = parent.addNode(nodeName, "rma:filePlan");
        filePlan.setProperty("rma:recordCategoryIdentifier", cateIdentify);
        filePlan.setProperty("rma:dispositionAuthority", disposition);
        filePlan.setProperty("rma:permanentRecordIndicator", permanentRecord);
        filePlan.setProperty("rma:containsRecordFolders", recordFolder);
        filePlan.setProperty("rma:defaultMediaType", mediaType);
        filePlan.setProperty("rma:defaultMarkingList", markingList);
        filePlan.setProperty("rma:defaultOriginatingOrganization", original);
        filePlan.setProperty("rma:vitalRecordIndicator", recordIndicator);
        filePlan.setProperty("rma:processCutoff", cutoff);
        filePlan.setProperty("rma:eventTrigger", eventTrigger);
        filePlan.setProperty("rma:processHold", processHold);
        filePlan.setProperty("rma:processTransfer", processTransfer);
        filePlan.setProperty("rma:processAccession", processAccession);
        filePlan.setProperty("rma:processDestruction", processDestruction);
        filePlan.setProperty("rma:vitalRecordReviewPeriod", vitalRecordReview);
        return filePlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartupWithOldDataStructure() throws Exception {
        RegistryService registry = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        String pathDefault = "exo:services/Audit/defaultIdentity";
        String pathAdmin = "exo:services/Audit/adminIdentity";
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            RegistryEntry registryEntry = registry.getEntry(sessionProvider, pathDefault);
            Document doc = registryEntry.getDocument();
            Element element = doc.getDocumentElement();
            String defaultIdentity = element.getAttribute("value");
            AuditServiceTest.assertNotNull((Object)defaultIdentity);
            registryEntry = registry.getEntry(sessionProvider, pathAdmin);
            doc = registryEntry.getDocument();
            element = doc.getDocumentElement();
            String adminIdentity = element.getAttribute("value");
            AuditServiceTest.assertNotNull((Object)adminIdentity);
            registry.removeEntry(sessionProvider, pathDefault);
            AuditServiceImpl as = (AuditServiceImpl)this.service;
            as.stop();
            as.start();
            registryEntry = registry.getEntry(sessionProvider, pathDefault);
            doc = registryEntry.getDocument();
            element = doc.getDocumentElement();
            AuditServiceTest.assertEquals((String)defaultIdentity, (String)element.getAttribute("value"));
            registryEntry = registry.getEntry(sessionProvider, pathAdmin);
            doc = registryEntry.getDocument();
            element = doc.getDocumentElement();
            AuditServiceTest.assertEquals((String)adminIdentity, (String)element.getAttribute("value"));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.exo1Session.logout();
        this.exo1Session = null;
        this.adminSession.save();
        this.adminSession.getRootNode().getNode(ROOT_PATH).remove();
        this.adminSession.save();
        this.adminSession.logout();
        this.adminSession = null;
        super.tearDown();
    }
}

