/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.index.persistent;

import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingQueueDAOImpl;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl;

public class JCRIndexingServiceTest
extends BaseStandaloneTest {
    private JCRIndexingServiceImpl jcrIndexingService;
    private JCRIndexingQueueDAOImpl indexingQueueDAO;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.indexingQueueDAO = (JCRIndexingQueueDAOImpl)ExoContainerContext.getService(JCRIndexingQueueDAOImpl.class);
        this.jcrIndexingService = (JCRIndexingServiceImpl)ExoContainerContext.getService(JCRIndexingServiceImpl.class);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        RequestLifeCycle.end();
    }

    public void testCreateIndexEntity() throws Exception {
        this.saveAndProcessQueue();
        Long initialCount = this.indexingQueueDAO.count();
        JCRIndexingServiceTest.assertNotNull((Object)initialCount);
        Node testRoot = this.session.getRootNode().addNode("testCreateIndexEntity");
        Node node = testRoot.addNode("exo:test");
        node.setProperty("jcr:prop", "property and node");
        this.saveAndProcessQueue();
        Long count = this.indexingQueueDAO.count();
        JCRIndexingServiceTest.assertNotNull((Object)count);
        JCRIndexingServiceTest.assertEquals((long)(initialCount + 2L), (long)count);
        this.jcrIndexingService.persistLastOperationId();
        String lastExecutedOperation = this.jcrIndexingService.getLastExecutedOperation();
        JCRIndexingServiceTest.assertTrue((boolean)lastExecutedOperation.contains(";ClusterNodeName"));
        lastExecutedOperation = lastExecutedOperation.replaceAll(";ClusterNodeName", "");
        JCRIndexingServiceTest.assertTrue((String)("Last executed queue operation '" + lastExecutedOperation + "' has to be greater or equals the number of elements in queue" + count), (Long.parseLong(lastExecutedOperation) >= count ? 1 : 0) != 0);
    }

    public void testUpdateIndexEntity() throws Exception {
        Node testRoot = this.session.getRootNode().addNode("testUpdateIndexEntity");
        Node node = testRoot.addNode("exo:test");
        node.setProperty("jcr:prop", "property and node");
        this.saveAndProcessQueue();
        Long initialCount = this.getQueueCount();
        JCRIndexingServiceTest.assertNotNull((Object)initialCount);
        node.setProperty("jcr:prop", "property and node 2");
        this.saveAndProcessQueue();
        Long count = this.indexingQueueDAO.count();
        JCRIndexingServiceTest.assertNotNull((Object)count);
        JCRIndexingServiceTest.assertEquals((long)(initialCount + 2L), (long)count);
        this.jcrIndexingService.persistLastOperationId();
        String lastExecutedOperation = this.jcrIndexingService.getLastExecutedOperation();
        JCRIndexingServiceTest.assertTrue((boolean)lastExecutedOperation.contains(";ClusterNodeName"));
        lastExecutedOperation = lastExecutedOperation.replaceAll(";ClusterNodeName", "");
        JCRIndexingServiceTest.assertTrue((Long.parseLong(lastExecutedOperation) >= count ? 1 : 0) != 0);
    }

    public void testRemoveIndexEntity() throws Exception {
        Node testRoot = this.session.getRootNode().addNode("testRemoveIndexEntity");
        Node node = testRoot.addNode("exo:test");
        node.setProperty("jcr:prop", "property and node");
        this.saveAndProcessQueue();
        Long initialCount = this.getQueueCount();
        JCRIndexingServiceTest.assertNotNull((Object)initialCount);
        node.remove();
        this.saveAndProcessQueue();
        Long count = this.getQueueCount();
        JCRIndexingServiceTest.assertNotNull((Object)count);
        JCRIndexingServiceTest.assertEquals((long)(initialCount - 1L + 1L), (long)count);
        this.jcrIndexingService.persistLastOperationId();
        String lastExecutedOperation = this.jcrIndexingService.getLastExecutedOperation();
        JCRIndexingServiceTest.assertTrue((boolean)lastExecutedOperation.contains(";ClusterNodeName"));
        lastExecutedOperation = lastExecutedOperation.replaceAll(";ClusterNodeName", "");
        JCRIndexingServiceTest.assertTrue((Long.parseLong(lastExecutedOperation) >= count ? 1 : 0) != 0);
    }

    private long getQueueCount() {
        return this.indexingQueueDAO.count();
    }

    private void saveAndProcessQueue() throws Exception {
        this.session.save();
        this.jcrIndexingService.persistQueueOperations();
    }
}

