/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.index.persistent.impl;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.index.persistent.JCRIndexingOperationType;
import org.exoplatform.services.jcr.ext.index.persistent.api.JCRIndexingQueueDAO;
import org.exoplatform.services.jcr.ext.index.persistent.api.JCRIndexingService;
import org.exoplatform.services.jcr.ext.index.persistent.api.TransientQueueEntrySet;
import org.exoplatform.services.jcr.ext.index.persistent.entity.JCRIndexQueueEntity;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.IndexRecovery;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCService;
import org.picocontainer.Startable;

public class JCRIndexingServiceImpl
implements JCRIndexingService,
Startable {
    public static final String LAST_OPERATION_FILE_NAME = "lastOperationID";
    private static final Log LOG = ExoLogger.getLogger(JCRIndexingServiceImpl.class);
    private static final String CLUSTER_NODE_NAME_PARAMETER = "cluster.node.name";
    private static final String BATCH_NUMBER_PARAM = "batch.number";
    private static final String QUEUE_PROCESSING_PERIOD_SECONDS_PARAM = "queue.periodicity.seconds";
    private final JCRIndexingQueueDAO indexingQueueDAO;
    private final RepositoryService repositoryService;
    private final EntityManagerService entityManagerService;
    private String repositoryName;
    private String clusterNodeName;
    private ThreadLocal<Boolean> isIndexingLocally = new ThreadLocal();
    private int queueProcessingPeriod = 5;
    private final ConcurrentLinkedQueue<TransientQueueEntrySet> transientQueueToPersist = new ConcurrentLinkedQueue();
    private ScheduledExecutorService filePersisterThread = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService queueProducingJobService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService queueConsumingJobService = Executors.newSingleThreadScheduledExecutor();
    private AtomicBoolean indexingOperationIsRunning = new AtomicBoolean();
    private AtomicLong storedLastOperationId = new AtomicLong(0L);
    private AtomicLong localLastOperationId = null;
    private File localLastOperationFile = null;
    private int batchNumber = 100;
    private ExoContainer container;
    private boolean initialized;

    public JCRIndexingServiceImpl(EntityManagerService entityManagerService, RepositoryService repositoryService, JCRIndexingQueueDAO indexingQueueDAO, InitParams params) {
        this.indexingQueueDAO = indexingQueueDAO;
        this.repositoryService = repositoryService;
        this.entityManagerService = entityManagerService;
        if (params.containsKey((Object)BATCH_NUMBER_PARAM)) {
            String batchNumberValue = params.getValueParam(BATCH_NUMBER_PARAM).getValue();
            try {
                this.batchNumber = Integer.parseInt(batchNumberValue);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid parameter {} with value {}. default value will be used", new Object[]{BATCH_NUMBER_PARAM, batchNumberValue, this.batchNumber});
            }
        }
        if (params.containsKey((Object)QUEUE_PROCESSING_PERIOD_SECONDS_PARAM)) {
            String value = params.getValueParam(QUEUE_PROCESSING_PERIOD_SECONDS_PARAM).getValue();
            try {
                this.queueProcessingPeriod = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid parameter {} with value {}. default value will be used", new Object[]{QUEUE_PROCESSING_PERIOD_SECONDS_PARAM, value, this.queueProcessingPeriod});
            }
        }
        String string = this.clusterNodeName = params.containsKey((Object)CLUSTER_NODE_NAME_PARAMETER) ? params.getValueParam(CLUSTER_NODE_NAME_PARAMETER).getValue() : null;
        if (StringUtils.isBlank((CharSequence)this.clusterNodeName)) {
            throw new IllegalStateException("cluster.node.name parameter is empty");
        }
    }

    @Override
    public synchronized void processIndexingQueue() throws Exception {
        if (!this.initialized || this.isIndexingInCurrentThread()) {
            return;
        }
        this.isIndexingLocally.set(true);
        this.computeCurrentContainer();
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        try {
            this.applyIndexChangesOnJCR();
        }
        finally {
            this.isIndexingLocally.remove();
            RequestLifeCycle.end();
        }
    }

    public void start() {
        if (this.container instanceof PortalContainer) {
            PortalContainer portalContainer = (PortalContainer)this.container;
            PortalContainer.addInitTask((ServletContext)portalContainer.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

                public void execute(ServletContext context, PortalContainer portalContainer) {
                    JCRIndexingServiceImpl.this.scheduleIndexTasks();
                }
            });
        }
    }

    public void stop() {
        if (!this.queueProducingJobService.isShutdown() && !this.queueProducingJobService.isTerminated()) {
            this.queueProducingJobService.shutdownNow();
        }
        if (!this.queueConsumingJobService.isShutdown() && !this.queueConsumingJobService.isTerminated()) {
            this.queueConsumingJobService.shutdownNow();
        }
        if (!this.filePersisterThread.isShutdown() && !this.filePersisterThread.isTerminated()) {
            this.filePersisterThread.shutdownNow();
        }
    }

    @Override
    public void applyIndexChangesOnQueue(ChangesFilterListsWrapper changes, String workspaceId) {
        this.applyIndexChangesOnQueue(changes.getRemovedNodes(), changes.getAddedNodes(), changes.getParentRemovedNodes(), changes.getParentAddedNodes(), workspaceId);
    }

    @Override
    public void applyIndexChangesOnQueue(Set<String> removedNodes, Set<String> addedNodes, Set<String> parentRemovedNodes, Set<String> parentAddedNodes, String workspaceId) {
        this.transientQueueToPersist.offer(new TransientQueueEntrySet(workspaceId, removedNodes, addedNodes, parentRemovedNodes, parentAddedNodes));
    }

    @Override
    public synchronized void init(QueryHandler handler, QueryHandlerEntry config) {
        if (this.initialized) {
            return;
        }
        LOG.debug((Object)"Initialize JCR QUEUE Indexing Service");
        this.retrieveLocalLastOperationFile();
        if (this.localLastOperationFile == null || !this.localLastOperationFile.exists()) {
            try {
                String indexDirPath = config.getParameter("index-dir").getValue();
                this.retrieveLastOperationIDFromCoordinator(handler, indexDirPath);
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to retrieve lastOperation file from coordinator", (Throwable)e);
            }
        }
        if (this.localLastOperationFile != null && this.localLastOperationFile.exists()) {
            this.updateQueueSwitchStatusInFile();
        }
        this.initialized = true;
    }

    @ExoTransactional
    public void applyIndexChangesOnJCR(List<JCRIndexQueueEntity> indexingQueueEntities) throws Exception {
        if (indexingQueueEntities == null || indexingQueueEntities.isEmpty()) {
            return;
        }
        Map<String, List<JCRIndexQueueEntity>> opByWorkspace = this.convertEntitiesToMapByWorkspace(indexingQueueEntities);
        Map<String, Map<Boolean, Map<JCRIndexingOperationType, Set<String>>>> opByWorkspaceByType = this.convertEntitiesToMapByWorkspaceByType(indexingQueueEntities);
        for (Map.Entry<String, Map<Boolean, Map<JCRIndexingOperationType, Set<String>>>> operationsByTypeEntry : opByWorkspaceByType.entrySet()) {
            String workspaceId = operationsByTypeEntry.getKey();
            SearchManager searchManager = this.getSearchManager(workspaceId);
            Map<Boolean, Map<JCRIndexingOperationType, Set<String>>> operationsByType = operationsByTypeEntry.getValue();
            Map<JCRIndexingOperationType, Set<String>> parentOpsByType = operationsByType.containsKey(true) ? operationsByType.get(true) : Collections.emptyMap();
            Map<JCRIndexingOperationType, Set<String>> opsByType = operationsByType.containsKey(false) ? operationsByType.get(false) : Collections.emptyMap();
            Set<String> parentAddedNodes = this.getJCRUUIDs(parentOpsByType, JCRIndexingOperationType.CREATE);
            Set<String> parentRemovedNodes = this.getJCRUUIDs(parentOpsByType, JCRIndexingOperationType.DELETE);
            Set<String> addedNodes = this.getJCRUUIDs(opsByType, JCRIndexingOperationType.CREATE);
            Set<String> removedNodes = this.getJCRUUIDs(opsByType, JCRIndexingOperationType.DELETE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("APPLY index to JCR: '{}' parent create & '{}' parent remove & '{}' create & '{}' remove", new Object[]{parentAddedNodes.size(), parentRemovedNodes.size(), addedNodes.size(), removedNodes.size()});
                for (String parentRemovedNode : parentRemovedNodes) {
                    LOG.debug("-  APPLY index to JCR: parent delete UUID = {}", new Object[]{parentRemovedNode});
                }
                for (String removedNode : removedNodes) {
                    LOG.debug("-  APPLY index to JCR: delete UUID = {}", new Object[]{removedNode});
                }
                for (String parentAddedNode : parentAddedNodes) {
                    LOG.debug("+  APPLY index to JCR: parent create UUID = {}", new Object[]{parentAddedNode});
                }
                for (String addedNode : addedNodes) {
                    LOG.debug("+  APPLY index to JCR: create UUID = {}", new Object[]{addedNode});
                }
            }
            ChangesHolder parentChanges = searchManager.getChanges(parentRemovedNodes, parentAddedNodes);
            ChangesHolder changes = searchManager.getChanges(removedNodes, addedNodes);
            searchManager.apply(parentChanges);
            searchManager.apply(changes);
            List<JCRIndexQueueEntity> operationsSucceeded = opByWorkspace.get(workspaceId);
            for (JCRIndexQueueEntity jcrIndexQueueEntity : operationsSucceeded) {
                jcrIndexQueueEntity.addNode(this.clusterNodeName);
                this.updateLastNewOperationId(jcrIndexQueueEntity.getId());
            }
            this.indexingQueueDAO.updateAll(operationsSucceeded);
        }
    }

    @ExoTransactional
    public List<JCRIndexQueueEntity> findNextOperations(int offset, int batchNumber) {
        return this.indexingQueueDAO.findAllOperationNotExecutedByClusterNode(offset, batchNumber, this.clusterNodeName);
    }

    @ExoTransactional
    public void index(String jcrUUID, String workspaceId, boolean parentChange) {
        if (this.isIndexingInCurrentThread()) {
            return;
        }
        this.checkIndexingArguments(jcrUUID, workspaceId);
        JCRIndexQueueEntity indexQueueEntity = this.addToIndexingQueue(jcrUUID, workspaceId, JCRIndexingOperationType.CREATE, parentChange);
        this.updateLastNewOperationId(indexQueueEntity.getId());
    }

    @ExoTransactional
    public void reindex(String jcrUUID, String workspaceId, boolean parentChange) {
        if (this.isIndexingInCurrentThread()) {
            return;
        }
        this.checkIndexingArguments(jcrUUID, workspaceId);
        JCRIndexQueueEntity indexQueueEntity = this.addToIndexingQueue(jcrUUID, workspaceId, JCRIndexingOperationType.UPDATE, parentChange);
        this.updateLastNewOperationId(indexQueueEntity.getId());
    }

    @ExoTransactional
    public void unindex(String jcrUUID, String workspaceId, boolean parentChange) {
        if (this.isIndexingInCurrentThread()) {
            return;
        }
        this.checkIndexingArguments(jcrUUID, workspaceId);
        JCRIndexQueueEntity indexQueueEntity = this.addToIndexingQueue(jcrUUID, workspaceId, JCRIndexingOperationType.DELETE, parentChange);
        this.updateLastNewOperationId(indexQueueEntity.getId());
    }

    @ExoTransactional
    public void unindexAll(String workspaceId) {
        if (this.isIndexingInCurrentThread()) {
            return;
        }
        this.checkIndexingArgument("workspaceId", workspaceId);
        JCRIndexQueueEntity indexQueueEntity = this.addToIndexingQueue("-", workspaceId, JCRIndexingOperationType.DELETE_ALL, false);
        this.updateLastNewOperationId(indexQueueEntity.getId());
    }

    @ExoTransactional
    public void updateQueueSwitchStatusInFile() {
        try {
            String lastExecutedOperation = this.getLastExecutedOperation();
            if (StringUtils.isBlank((CharSequence)lastExecutedOperation)) {
                return;
            }
            String[] lastExecutedIdArray = lastExecutedOperation.split(";");
            String oldClusterNodeName = lastExecutedIdArray[1];
            String lastExecutedIdString = lastExecutedIdArray[0];
            if (!this.clusterNodeName.equals(oldClusterNodeName) && StringUtils.isNotBlank((CharSequence)lastExecutedIdString)) {
                LOG.debug((Object)"Start: Update Queue with last status because the indexes was manually copied");
                int offset = 0;
                int proceededOperations = 0;
                int totalProceededOperations = 0;
                long lastExecutedId = Long.parseLong(lastExecutedIdString);
                Long totalIndexingOperations = this.indexingQueueDAO.count();
                do {
                    List<JCRIndexQueueEntity> indexingQueueEntities = this.indexingQueueDAO.findAllOperationExecutedByClusterNode(oldClusterNodeName, this.clusterNodeName, lastExecutedId, offset, this.batchNumber);
                    for (JCRIndexQueueEntity jcrIndexQueueEntity : indexingQueueEntities) {
                        jcrIndexQueueEntity.addNode(this.clusterNodeName);
                    }
                    this.indexingQueueDAO.updateAll(indexingQueueEntities);
                    proceededOperations = indexingQueueEntities.size();
                    LOG.debug("Retrieved indexes update: {} / {}", new Object[]{totalProceededOperations += proceededOperations, totalIndexingOperations});
                } while (proceededOperations == this.batchNumber);
                LOG.debug("End: Update Queue with last status because the indexes was manually copied. Total indexes updates: {} / {}", new Object[]{totalProceededOperations, totalIndexingOperations});
                this.updateLastNewOperationId(lastExecutedId);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't read file JCR queue indexing last operation id", e);
        }
    }

    public String getLastExecutedOperation() {
        if (this.localLastOperationFile == null || !this.localLastOperationFile.exists()) {
            return null;
        }
        try {
            return IOUtil.getFileContentAsString((File)this.localLastOperationFile);
        }
        catch (IOException e) {
            LOG.error((Object)"An error occurred while retrieving last operation id from file", (Throwable)e);
            return null;
        }
    }

    public int getQueueProcessingPeriod() {
        return this.queueProcessingPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistQueueOperations() {
        this.computeCurrentContainer();
        while (this.transientQueueToPersist.peek() != null) {
            TransientQueueEntrySet queueEntrySet = this.transientQueueToPersist.poll();
            Set<String> addedNodes = queueEntrySet.getAddedNodes();
            Set<String> parentAddedNodes = queueEntrySet.getParentAddedNodes();
            Set<String> removedNodes = queueEntrySet.getRemovedNodes();
            Set<String> parentRemovedNodes = queueEntrySet.getParentRemovedNodes();
            String workspaceId = queueEntrySet.getWorkspace();
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PUSH to queue index: '{}' parent create & '{}' parent remove & '{}' create & '{}' remove", new Object[]{parentAddedNodes.size(), parentRemovedNodes.size(), addedNodes.size(), removedNodes.size()});
                    for (String parentRemovedNode : parentRemovedNodes) {
                        LOG.debug("-  PUSH to queue index: parent delete UUID = {}", new Object[]{parentRemovedNode});
                    }
                    for (String removedNode : removedNodes) {
                        LOG.debug("-  PUSH to queue index: delete UUID = {}", new Object[]{removedNode});
                    }
                    for (String parentAddedNode : parentAddedNodes) {
                        LOG.debug("+  PUSH to queue index: parent create UUID = {}", new Object[]{parentAddedNode});
                    }
                    for (String addedNode : addedNodes) {
                        LOG.debug("+  PUSH to queue index: create UUID = {}", new Object[]{addedNode});
                    }
                }
                for (String removeNodeUUID : parentRemovedNodes) {
                    if (!parentAddedNodes.contains(removeNodeUUID)) {
                        LOG.debug("Delete all previous indexing operations with JCR UUID '{}' since the node was deleted", new Object[]{removeNodeUUID});
                        this.indexingQueueDAO.deleteOperationsByJCRUUID(removeNodeUUID);
                    }
                    this.unindex(removeNodeUUID, workspaceId, true);
                }
                for (String removeNodeUUID : removedNodes) {
                    if (!addedNodes.contains(removeNodeUUID)) {
                        LOG.debug("Delete all previous indexing operations with JCR UUID '{}' since the node was deleted", new Object[]{removeNodeUUID});
                        this.indexingQueueDAO.deleteOperationsByJCRUUID(removeNodeUUID);
                    }
                    this.unindex(removeNodeUUID, workspaceId, false);
                }
                for (String addedNodeUUID : parentAddedNodes) {
                    this.index(addedNodeUUID, workspaceId, true);
                }
                for (String addedNodeUUID : addedNodes) {
                    this.index(addedNodeUUID, workspaceId, false);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while applying changes", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private void retrieveLastOperationIDFromCoordinator(QueryHandler handler, String indexDirPath) throws Exception {
        IndexRecovery indexRecovery = handler.getContext().getIndexRecovery();
        File indexDirFile = new File(indexDirPath);
        File lastOperationFile = new File(indexDirFile.getParentFile(), LAST_OPERATION_FILE_NAME);
        if (lastOperationFile.exists()) {
            this.localLastOperationFile = lastOperationFile;
            return;
        }
        if (!handler.getContext().isRecoveryFilterUsed() || handler.getContext().getIndexRecovery() == null) {
            return;
        }
        RPCService rpcService = handler.getContext().getRPCService();
        if (rpcService == null || rpcService.isCoordinator()) {
            return;
        }
        LOG.debug((Object)"Retriving last executed queue operation file from coordinator");
        InputStream indexFile = indexRecovery.getIndexFile("../lastOperationID");
        try (FileOutputStream outputStream = new FileOutputStream(lastOperationFile);){
            IOUtils.copy((InputStream)indexFile, (OutputStream)outputStream);
            outputStream.flush();
        }
    }

    private void applyIndexChangesOnJCR() throws Exception {
        int offset = 0;
        int proceededOperations = 0;
        do {
            List<JCRIndexQueueEntity> indexingQueueEntities = this.findNextOperations(offset, this.batchNumber);
            proceededOperations = indexingQueueEntities.size();
            this.applyIndexChangesOnJCR(indexingQueueEntities);
        } while (proceededOperations == this.batchNumber);
    }

    private void updateLastNewOperationId(long id) {
        this.checkStoredLastOperationId();
        this.localLastOperationId.getAndUpdate(value -> id > value ? id : value);
    }

    public void persistLastOperationId() {
        this.retrieveLocalLastOperationFile();
        if (this.localLastOperationFile == null) {
            LOG.error((Object)"JCR Index parent directory wasn't found. Can't save last indexed operation.");
            return;
        }
        this.checkStoredLastOperationId();
        long id = this.localLastOperationId.get();
        if (this.storedLastOperationId.get() >= id) {
            return;
        }
        LOG.debug("Persist last index operation id: {}", new Object[]{id});
        try (FileOutputStream outputStream = new FileOutputStream(this.localLastOperationFile);){
            String fileContent = id + ";" + this.clusterNodeName;
            outputStream.write(fileContent.getBytes());
            outputStream.flush();
            this.storedLastOperationId.set(id);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while writing last operation ID ", (Throwable)e);
        }
    }

    private void checkStoredLastOperationId() {
        if (this.localLastOperationId == null) {
            String lastExecutedOperation = this.getLastExecutedOperation();
            if (StringUtils.isNotBlank((CharSequence)lastExecutedOperation)) {
                String[] lastExecutedIdArray = lastExecutedOperation.split(";");
                String lastExecutedIdString = lastExecutedIdArray[0];
                this.localLastOperationId = new AtomicLong(Long.parseLong(lastExecutedIdString));
            } else {
                this.localLastOperationId = new AtomicLong(0L);
            }
            this.storedLastOperationId.set(this.localLastOperationId.get());
        }
    }

    private JCRIndexQueueEntity addToIndexingQueue(String jcrUUID, String workspaceId, JCRIndexingOperationType operationType, boolean parentChange) {
        if (operationType == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        JCRIndexQueueEntity indexingEntity = this.getIndexingEntity(jcrUUID, workspaceId, operationType, parentChange);
        indexingEntity = (JCRIndexQueueEntity)this.indexingQueueDAO.create(indexingEntity);
        return indexingEntity;
    }

    private boolean isIndexingInCurrentThread() {
        return this.isIndexingLocally.get() != null && this.isIndexingLocally.get() != false;
    }

    private JCRIndexQueueEntity getIndexingEntity(String jcrUUID, String workspaceId, JCRIndexingOperationType operationType, boolean parentChange) {
        return new JCRIndexQueueEntity(jcrUUID, workspaceId, operationType, Calendar.getInstance(), parentChange, this.clusterNodeName);
    }

    private void retrieveLocalLastOperationFile() {
        if (this.localLastOperationFile != null) {
            return;
        }
        String workspaceIndexDirName = this.getSystemWorkspaceIndexDirectory();
        if (StringUtils.isBlank((CharSequence)workspaceIndexDirName)) {
            return;
        }
        File workspaceIndexFolder = new File(workspaceIndexDirName);
        File rootIndexFolder = workspaceIndexFolder.getParentFile();
        if (!rootIndexFolder.exists()) {
            rootIndexFolder.mkdirs();
        }
        this.localLastOperationFile = new File(rootIndexFolder, LAST_OPERATION_FILE_NAME);
    }

    private String getSystemWorkspaceIndexDirectory() {
        String indexDirName = null;
        try {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            String systemWorkspaceName = repository.getConfiguration().getSystemWorkspaceName();
            WorkspaceContainerFacade workspaceContainer = repository.getWorkspaceContainer(systemWorkspaceName);
            WorkspaceEntry workspaceEntry = (WorkspaceEntry)workspaceContainer.getComponent(WorkspaceEntry.class);
            indexDirName = workspaceEntry.getQueryHandler().getParameterValue("index-dir");
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting system workspace configuration");
        }
        return indexDirName;
    }

    private void checkIndexingArguments(String jcrUUID, String workspaceId) {
        this.checkIndexingArgument("workspaceId", workspaceId);
        this.checkIndexingArgument("jcrUUID", jcrUUID);
    }

    private void checkIndexingArgument(String name, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    private SearchManager getSearchManager(String workspaceId) throws RepositoryException {
        if (StringUtils.isBlank((CharSequence)workspaceId)) {
            throw new IllegalArgumentException("Workspace id is null");
        }
        if (!workspaceId.contains(this.getRepositoryName())) {
            throw new IllegalArgumentException("Workspace id '" + workspaceId + "' doesn't match pattern '" + this.getRepositoryName() + "_WORKSPACENAME' ");
        }
        String workspaceName = workspaceId.replace(this.getRepositoryName() + "_", "");
        WorkspaceContainerFacade workspaceContainer = this.repositoryService.getCurrentRepository().getWorkspaceContainer(workspaceName);
        if (workspaceContainer == null) {
            throw new IllegalStateException("Can't find workspace container with name " + workspaceName);
        }
        return (SearchManager)workspaceContainer.getComponent(SearchManager.class);
    }

    private String getRepositoryName() {
        if (this.repositoryName == null) {
            try {
                this.repositoryName = this.repositoryService.getConfig().getDefaultRepositoryName();
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't get current repository name from repository service", e);
            }
        }
        return this.repositoryName;
    }

    private Set<String> getJCRUUIDs(Map<JCRIndexingOperationType, Set<String>> operationsByType, JCRIndexingOperationType operationType) {
        Set<String> nodesUUIDSet;
        Set<String> set = nodesUUIDSet = operationsByType.containsKey((Object)operationType) ? operationsByType.get((Object)operationType) : null;
        if (nodesUUIDSet == null) {
            nodesUUIDSet = Collections.emptySet();
        }
        return nodesUUIDSet;
    }

    private Map<String, Map<Boolean, Map<JCRIndexingOperationType, Set<String>>>> convertEntitiesToMapByWorkspaceByType(List<JCRIndexQueueEntity> indexingQueueEntities) {
        return indexingQueueEntities.stream().collect(Collectors.groupingBy(JCRIndexQueueEntity::getWorkspace, Collectors.groupingBy(JCRIndexQueueEntity::isParentChange, Collectors.groupingBy(JCRIndexQueueEntity::getOperationType, Collectors.mapping(JCRIndexQueueEntity::getJcrUUID, Collectors.toSet())))));
    }

    private Map<String, List<JCRIndexQueueEntity>> convertEntitiesToMapByWorkspace(List<JCRIndexQueueEntity> indexingQueueEntities) {
        return indexingQueueEntities.stream().collect(Collectors.groupingBy(JCRIndexQueueEntity::getWorkspace, Collectors.toList()));
    }

    private void computeCurrentContainer() {
        if (this.container == null) {
            this.container = ExoContainerContext.getCurrentContainerIfPresent();
        }
        if (this.container instanceof RootContainer) {
            this.container = PortalContainer.getInstance();
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
    }

    private void scheduleIndexTasks() {
        this.retrieveLocalLastOperationFile();
        this.checkStoredLastOperationId();
        this.queueConsumingJobService.scheduleAtFixedRate(() -> {
            if (this.indexingOperationIsRunning.get()) {
                LOG.debug((Object)"Previous QUEUE indexing processing task is always executing, skip this execution");
                return;
            }
            this.indexingOperationIsRunning.set(true);
            this.computeCurrentContainer();
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
            try {
                LOG.debug((Object)"Running JCR Index from DB QUEUE Task");
                this.processIndexingQueue();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while Running JCR nodes indexing operation", (Throwable)e);
            }
            finally {
                this.indexingOperationIsRunning.set(false);
                RequestLifeCycle.end();
            }
        }, 0L, this.queueProcessingPeriod, TimeUnit.SECONDS);
        this.queueProducingJobService.scheduleAtFixedRate(() -> this.persistQueueOperations(), 0L, this.queueProcessingPeriod, TimeUnit.SECONDS);
        this.filePersisterThread.scheduleAtFixedRate(() -> this.persistLastOperationId(), 0L, 10L, TimeUnit.SECONDS);
    }
}

