/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirClientRequestListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.util.ObjectUtil;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;

public class ClientConnectionManager
implements Configurable {
    private ORB orb = null;
    private Map connections = new HashMap();
    private SocketFactory socket_factory = null;
    private SocketFactory ssl_socket_factory = null;
    private RequestListener request_listener = null;
    private MessageReceptorPool receptor_pool = null;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    static /* synthetic */ Class class$org$jacorb$orb$ORB;

    public ClientConnectionManager(ORB oRB, TransportManager transportManager, GIOPConnectionManager gIOPConnectionManager) {
        this.orb = oRB;
        this.transport_manager = transportManager;
        this.giop_connection_manager = gIOPConnectionManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.receptor_pool = MessageReceptorPool.getInstance(configuration);
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.giop");
        this.request_listener = new NoBiDirClientRequestListener(this.logger);
        this.socket_factory = this.transport_manager.getSocketFactoryManager().getSocketFactory();
        if (this.configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on")) {
            String string = this.configuration.getAttribute("jacorb.ssl.socket_factory", "");
            if (string.length() == 0) {
                throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class clazz = ObjectUtil.classForName(string);
                Constructor constructor = clazz.getConstructor(class$org$jacorb$orb$ORB == null ? (class$org$jacorb$orb$ORB = ClientConnectionManager.class$("org.jacorb.orb.ORB")) : class$org$jacorb$orb$ORB);
                this.ssl_socket_factory = (SocketFactory)constructor.newInstance(this.orb);
            }
            catch (Exception exception) {
                throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instantiated (" + exception.getMessage() + ")!");
            }
        }
    }

    public void setRequestListener(RequestListener requestListener) {
        this.request_listener = requestListener;
    }

    public synchronized ClientConnection getConnection(Profile profile) {
        ClientConnection clientConnection = (ClientConnection)this.connections.get(profile);
        if (clientConnection == null) {
            int n = profile.tag();
            Factories factories = this.transport_manager.getFactories(n);
            if (factories == null) {
                throw new RuntimeException("No transport plugin for profile tag " + n);
            }
            GIOPConnection gIOPConnection = this.giop_connection_manager.createClientGIOPConnection(profile, factories.create_connection(null), this.request_listener, null);
            clientConnection = new ClientConnection(gIOPConnection, this.orb, this, profile, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ClientConnectionManager: created new " + clientConnection.getGIOPConnection().toString());
            }
            this.connections.put(profile, clientConnection);
            this.receptor_pool.connectionCreated(gIOPConnection);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("ClientConnectionManager: found " + clientConnection.getGIOPConnection().toString());
        }
        clientConnection.incClients();
        return clientConnection;
    }

    public synchronized void releaseConnection(ClientConnection clientConnection) {
        if (clientConnection.decClients()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ClientConnectionManager: releasing " + clientConnection.getGIOPConnection().toString());
            }
            clientConnection.close();
            this.connections.remove(clientConnection.getRegisteredProfile());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("ClientConnectionManager: cannot release " + clientConnection.getGIOPConnection().toString() + " (still has " + clientConnection.numClients() + " client(s))");
        }
    }

    public synchronized void removeConnection(ClientConnection clientConnection) {
        this.connections.remove(clientConnection.getRegisteredProfile());
    }

    public synchronized void addConnection(GIOPConnection gIOPConnection, Profile profile) {
        if (!this.connections.containsKey(profile)) {
            ClientConnection clientConnection = new ClientConnection(gIOPConnection, this.orb, this, profile, false);
            clientConnection.incClients();
            this.connections.put(profile, clientConnection);
        }
    }

    public void shutdown() {
        Iterator iterator = this.connections.values().iterator();
        while (iterator.hasNext()) {
            ((ClientConnection)iterator.next()).close();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ClientConnectionManager shut down (all connections released)");
        }
        this.connections.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

