/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import java.util.List;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsGroup;
import org.ow2.carol.rmi.jrmp.server.JLocalObjectStore;
import org.ow2.carol.rmi.jrmp.server.JUnicastRef;
import org.ow2.carol.rmi.jrmp.server.JUnicastServerRef;
import org.ow2.carol.rmi.jrmp.server.JUnicastServerRefSf;
import sun.rmi.transport.ObjectTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnicastRemoteObject
extends RemoteServer {
    private static final long serialVersionUID = 5385452936766764864L;
    protected RMIClientSocketFactory csf = null;
    protected RMIServerSocketFactory ssf = null;

    protected JUnicastRemoteObject(List<JInterceptorsGroup> jinterceptorsList) throws RemoteException {
        this(0, jinterceptorsList);
    }

    protected JUnicastRemoteObject(int p, List<JInterceptorsGroup> jinterceptorsList) throws RemoteException {
        JUnicastRemoteObject.exportObject(this, p, jinterceptorsList);
    }

    protected JUnicastRemoteObject(int p, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, List<JInterceptorsGroup> jinterceptorsList) throws RemoteException {
        this.csf = csf;
        this.ssf = ssf;
        JUnicastRemoteObject.exportObject(this, p, csf, ssf, jinterceptorsList);
    }

    protected void exportObject(List<JInterceptorsGroup> jinterceptorsList) throws RemoteException {
        if (this.csf == null && this.ssf == null) {
            JUnicastRemoteObject.exportObject(this, 0, jinterceptorsList);
        } else {
            JUnicastRemoteObject.exportObject(this, 0, this.csf, this.ssf, jinterceptorsList);
        }
    }

    public static RemoteStub exportObject(Remote obj, List<JInterceptorsGroup> jinterceptorsList) throws RemoteException {
        return (RemoteStub)JUnicastRemoteObject.exportObject(obj, 0, jinterceptorsList);
    }

    public static Remote exportObject(Remote obj, int p, List<JInterceptorsGroup> jinterceptorsList) throws RemoteException {
        return JUnicastRemoteObject.exportObjectR(obj, new JUnicastServerRef(p, jinterceptorsList));
    }

    public static Remote exportObject(Remote obj, int p, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, List<JInterceptorsGroup> jinterceptorsList) throws RemoteException {
        return JUnicastRemoteObject.exportObjectR(obj, new JUnicastServerRefSf(p, csf, ssf, jinterceptorsList));
    }

    protected static Remote exportObjectR(Remote obj, JUnicastServerRef serverRef) throws RemoteException {
        int localId = -2;
        if (Boolean.getBoolean("rmi.local.call")) {
            localId = JLocalObjectStore.storeObject(obj);
        }
        if (obj instanceof JUnicastRemoteObject) {
            ((JUnicastRemoteObject)obj).ref = serverRef;
        }
        Remote rob = serverRef.exportObject(obj, null, localId);
        return rob;
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        if (Boolean.getBoolean("rmi.local.call")) {
            JUnicastRef remoteref = (JUnicastRef)((RemoteStub)ObjectTable.getStub(obj)).getRef();
            JLocalObjectStore.removeObject(remoteref.getLocalId());
        }
        return ObjectTable.unexportObject(obj, force);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.exportObject(null);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            JUnicastRemoteObject cloned = (JUnicastRemoteObject)super.clone();
            cloned.exportObject(null);
            return cloned;
        }
        catch (RemoteException e) {
            throw new ServerCloneException("Clone failed", e);
        }
    }
}

