/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectBuilder {
    static final Collection<String> SKIP_METHODS = new HashSet<String>();

    public static Object createArray(Class<?> clazz, JsonValue jsonArray) throws JsonException {
        Object array;
        block10: {
            array = null;
            if (jsonArray == null || jsonArray.isNull()) break block10;
            Class<?> componentType = clazz.getComponentType();
            array = Array.newInstance(componentType, jsonArray.size());
            Iterator<JsonValue> values = jsonArray.getElements();
            int i = 0;
            if (componentType.isArray()) {
                if (JsonUtils.isKnownType(componentType)) {
                    while (values.hasNext()) {
                        JsonValue v = values.next();
                        Array.set(array, i++, ObjectBuilder.createObjectKnownTypes(componentType, v));
                    }
                } else {
                    while (values.hasNext()) {
                        JsonValue v = values.next();
                        Array.set(array, i++, ObjectBuilder.createArray(componentType, v));
                    }
                }
            } else if (JsonUtils.isKnownType(componentType)) {
                while (values.hasNext()) {
                    JsonValue v = values.next();
                    Array.set(array, i++, ObjectBuilder.createObjectKnownTypes(componentType, v));
                }
            } else {
                while (values.hasNext()) {
                    JsonValue v = values.next();
                    Array.set(array, i++, ObjectBuilder.createObject(componentType, v));
                }
            }
        }
        return array;
    }

    public static <T extends Collection<?>> T createCollection(Class<T> collectionClass, Type genericType, JsonValue jsonArray) throws JsonException {
        Collection collection = null;
        if (jsonArray != null && !jsonArray.isNull()) {
            Class actualType = null;
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                try {
                    actualType = (Class)parameterizedType.getActualTypeArguments()[0];
                }
                catch (ClassCastException e) {
                    throw new JsonException("This type of Collection can't be restored from JSON source. \nCollection is parameterized by wrong Type: " + parameterizedType + ".");
                }
            } else {
                throw new JsonException("Collection is not parameterized. Collection<?> is not supported. \nCollection must be parameterized by any types, or by JavaBean with 'get' and 'set' methods.");
            }
            Constructor<T> constructor = null;
            if (collectionClass.isInterface() || Modifier.isAbstract(collectionClass.getModifiers())) {
                try {
                    constructor = ArrayList.class.asSubclass(collectionClass).getConstructor(Collection.class);
                }
                catch (Exception e) {
                    try {
                        constructor = HashSet.class.asSubclass(collectionClass).getConstructor(Collection.class);
                    }
                    catch (Exception e1) {
                        try {
                            constructor = LinkedList.class.asSubclass(collectionClass).getConstructor(Collection.class);
                        }
                        catch (Exception e2) {}
                    }
                }
            } else {
                try {
                    constructor = collectionClass.getConstructor(Collection.class);
                }
                catch (Exception e) {
                    throw new JsonException(e.getMessage(), e);
                }
            }
            if (constructor == null) {
                throw new JsonException("Can't find satisfied constructor for : " + collectionClass);
            }
            ArrayList<Object> sourceCollection = new ArrayList<Object>(jsonArray.size());
            Iterator<JsonValue> values = jsonArray.getElements();
            while (values.hasNext()) {
                JsonValue v = values.next();
                if (!JsonUtils.isKnownType(actualType)) {
                    sourceCollection.add(ObjectBuilder.createObject(actualType, v));
                    continue;
                }
                sourceCollection.add(ObjectBuilder.createObjectKnownTypes(actualType, v));
            }
            try {
                collection = (Collection)constructor.newInstance(sourceCollection);
            }
            catch (Exception e) {
                throw new JsonException(e.getMessage(), e);
            }
        }
        return (T)collection;
    }

    public static <T extends Map<String, ?>> T createObject(Class<T> mapClass, Type genericType, JsonValue jsonObject) throws JsonException {
        Map map = null;
        if (jsonObject != null && !jsonObject.isNull()) {
            Class valueActualType = null;
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                if (!String.class.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) {
                    throw new JsonException("Key of Map must be String. ");
                }
                try {
                    valueActualType = (Class)parameterizedType.getActualTypeArguments()[1];
                }
                catch (ClassCastException e) {
                    throw new JsonException("This type of Map can't be restored from JSON source.\nMap is parameterized by wrong Type: " + parameterizedType + ".");
                }
            } else {
                throw new JsonException("Map is not parameterized. Map<Sting, ?> is not supported.\nMap must be parameterized by String and any types or JavaBean with 'get' and 'set' methods.");
            }
            Constructor<T> constructor = null;
            if (mapClass.isInterface() || Modifier.isAbstract(mapClass.getModifiers())) {
                try {
                    constructor = HashMap.class.asSubclass(mapClass).getConstructor(Map.class);
                }
                catch (Exception e) {
                    try {
                        constructor = Hashtable.class.asSubclass(mapClass).getConstructor(Map.class);
                    }
                    catch (Exception e1) {
                        try {
                            constructor = LinkedHashMap.class.asSubclass(mapClass).getConstructor(Map.class);
                        }
                        catch (Exception e2) {}
                    }
                }
            } else {
                try {
                    constructor = mapClass.getConstructor(Map.class);
                }
                catch (Exception e) {
                    throw new JsonException(e.getMessage(), e);
                }
            }
            if (constructor == null) {
                throw new JsonException("Can't find satisfied constructor for : " + mapClass);
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>(jsonObject.size());
            Iterator<String> keys = jsonObject.getKeys();
            while (keys.hasNext()) {
                String k = keys.next();
                JsonValue v = jsonObject.getElement(k);
                if (!JsonUtils.isKnownType(valueActualType)) {
                    sourceMap.put(k, ObjectBuilder.createObject(valueActualType, v));
                    continue;
                }
                sourceMap.put(k, ObjectBuilder.createObjectKnownTypes(valueActualType, v));
            }
            try {
                map = (Map)constructor.newInstance(sourceMap);
            }
            catch (Exception e) {
                throw new JsonException(e.getMessage(), e);
            }
        }
        return (T)map;
    }

    public static <T> T createObject(Class<T> clazz, JsonValue jsonValue) throws JsonException {
        Method[] methods;
        if (jsonValue == null || jsonValue.isNull()) {
            return null;
        }
        JsonUtils.Types type = JsonUtils.getType(clazz);
        if (type == JsonUtils.Types.ENUM) {
            Class<T> c = clazz;
            return Enum.valueOf(c, jsonValue.getStringValue());
        }
        if (!jsonValue.isObject()) {
            throw new JsonException("Unsupported type of jsonValue. ");
        }
        T object = null;
        try {
            object = clazz.newInstance();
        }
        catch (Exception e) {
            throw new JsonException("Unable instantiate object. " + e.getMessage(), e);
        }
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (SKIP_METHODS.contains(methodName) || !methodName.startsWith("set") || parameterTypes.length != 1 || methodName.length() <= 3) continue;
            Class<?> methodParameterClass = parameterTypes[0];
            String key = methodName.substring(3);
            key = key.length() > 1 ? Character.toLowerCase(key.charAt(0)) + key.substring(1) : key.toLowerCase();
            JsonValue childJsonValue = jsonValue.getElement(key);
            if (childJsonValue == null) continue;
            try {
                if (JsonUtils.isKnownType(methodParameterClass)) {
                    method.invoke(object, ObjectBuilder.createObjectKnownTypes(methodParameterClass, childJsonValue));
                    continue;
                }
                JsonUtils.Types parameterType = JsonUtils.getType(methodParameterClass);
                if (parameterType != null) {
                    Class<?> c;
                    if (parameterType == JsonUtils.Types.ENUM) {
                        c = methodParameterClass;
                        Object en = Enum.valueOf(c, childJsonValue.getStringValue());
                        method.invoke(object, en);
                        continue;
                    }
                    if (parameterType == JsonUtils.Types.ARRAY_OBJECT) {
                        Object array = ObjectBuilder.createArray(methodParameterClass, childJsonValue);
                        method.invoke(object, array);
                        continue;
                    }
                    if (parameterType == JsonUtils.Types.COLLECTION) {
                        c = methodParameterClass;
                        method.invoke(object, ObjectBuilder.createCollection(c, method.getGenericParameterTypes()[0], childJsonValue));
                        continue;
                    }
                    if (parameterType == JsonUtils.Types.MAP) {
                        c = methodParameterClass;
                        method.invoke(object, ObjectBuilder.createObject(c, method.getGenericParameterTypes()[0], childJsonValue));
                        continue;
                    }
                    throw new JsonException("Can't restore parameter of method : " + clazz.getName() + "#" + method.getName() + " from JSON source.");
                }
                method.invoke(object, ObjectBuilder.createObject(methodParameterClass, childJsonValue));
            }
            catch (Exception e) {
                throw new JsonException("Unable restore parameter via method " + clazz.getName() + "#" + method.getName() + ". " + e.getMessage(), e);
            }
        }
        return object;
    }

    private static Object createObjectKnownTypes(Class<?> clazz, JsonValue jsonValue) throws JsonException {
        JsonUtils.Types t = JsonUtils.getType(clazz);
        switch (t) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return jsonValue.getBooleanValue();
            }
            case BYTE: {
                return jsonValue.getByteValue();
            }
            case SHORT: {
                return jsonValue.getShortValue();
            }
            case INT: {
                return jsonValue.getIntValue();
            }
            case LONG: {
                return jsonValue.getLongValue();
            }
            case FLOAT: {
                return Float.valueOf(jsonValue.getFloatValue());
            }
            case DOUBLE: {
                return jsonValue.getDoubleValue();
            }
            case CHAR: {
                return Character.valueOf(jsonValue.getStringValue().charAt(0));
            }
            case STRING: {
                return jsonValue.getStringValue();
            }
            case CLASS: {
                try {
                    return Class.forName(jsonValue.getStringValue());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            case ARRAY_BOOLEAN: {
                boolean[] params = new boolean[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getBooleanValue();
                }
                return params;
            }
            case ARRAY_BYTE: {
                byte[] params = new byte[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getByteValue();
                }
                return params;
            }
            case ARRAY_SHORT: {
                short[] params = new short[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getShortValue();
                }
                return params;
            }
            case ARRAY_INT: {
                int[] params = new int[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getIntValue();
                }
                return params;
            }
            case ARRAY_LONG: {
                long[] params = new long[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getLongValue();
                }
                return params;
            }
            case ARRAY_FLOAT: {
                float[] params = new float[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getFloatValue();
                }
                return params;
            }
            case ARRAY_DOUBLE: {
                double[] params = new double[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getDoubleValue();
                }
                return params;
            }
            case ARRAY_CHAR: {
                char[] params = new char[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getStringValue().charAt(0);
                }
                return params;
            }
            case ARRAY_STRING: {
                String[] params = new String[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getStringValue();
                }
                return params;
            }
        }
        throw new JsonException("Unknown type " + clazz.getName());
    }

    static {
        SKIP_METHODS.add("setMetaClass");
    }
}

