/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import java.util.Collections;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.EventPhaseContext;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.event.WindowEvent;

class EventControllerContextSafeInvoker {
    private final Log log = ExoLogger.getLogger(EventControllerContextSafeInvoker.class);

    EventControllerContextSafeInvoker() {
    }

    public Iterable<WindowEvent> eventProduced(EventControllerContext controllerContext, EventPhaseContext phaseContext, WindowEvent sourceEvent, WindowEvent producedEvent) {
        try {
            return controllerContext.eventProduced(phaseContext, producedEvent, sourceEvent);
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot deliver produced event " + producedEvent + " because the event controller context threw a runtime exception"), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean eventConsumed(EventControllerContext controllerContext, EventPhaseContext phaseContext, WindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
        try {
            controllerContext.eventConsumed(phaseContext, consumedEvent, consumerResponse);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"Event consumed callback threw an exception that is ignored by the controller", (Throwable)e);
            return false;
        }
    }

    public boolean eventFailed(EventControllerContext controllerContext, EventPhaseContext phaseContext, WindowEvent failedEvent, Throwable throwable) {
        try {
            controllerContext.eventFailed(phaseContext, failedEvent, throwable);
            return true;
        }
        catch (Exception e1) {
            this.log.error((Object)"Event delivery failed callback threw an exception that is ignored by the controller", (Throwable)e1);
            return false;
        }
    }

    public boolean eventDiscarded(EventControllerContext controllerContext, EventPhaseContext phaseContext, WindowEvent discardedEvent, int cause) {
        try {
            controllerContext.eventDiscarded(phaseContext, discardedEvent, cause);
            return true;
        }
        catch (Exception e1) {
            this.log.error((Object)"Event delivery failed callback threw an exception that is ignored by the controller", (Throwable)e1);
            return false;
        }
    }
}

