/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.pc.controller.state.WindowNavigationalState;

public final class PageNavigationalState {
    protected final Map<String, WindowNavigationalState> windows;
    protected final Map<QName, String[]> page;
    private final boolean modifiable;

    public PageNavigationalState(boolean modifiable) {
        this.windows = new HashMap<String, WindowNavigationalState>();
        this.page = new HashMap<QName, String[]>();
        this.modifiable = modifiable;
    }

    public PageNavigationalState(PageNavigationalState original, boolean modifiable) {
        this.windows = new HashMap<String, WindowNavigationalState>(original.windows);
        this.page = new HashMap<QName, String[]>(original.page);
        this.modifiable = modifiable;
    }

    public Set<String> getWindowIds() {
        return this.windows.keySet();
    }

    public WindowNavigationalState getWindowNavigationalState(String windowId) throws IllegalArgumentException {
        return this.windows.get(windowId);
    }

    public void setWindowNavigationalState(String windowId, WindowNavigationalState windowState) throws IllegalArgumentException, IllegalStateException {
        if (!this.modifiable) {
            throw new IllegalStateException("The page navigational state is not modifiable");
        }
        this.windows.put(windowId, windowState);
    }

    public Set<QName> getPublicNames() {
        return this.page.keySet();
    }

    public String[] getPublicNavigationalState(QName name) throws IllegalArgumentException {
        String[] values = this.page.get(name);
        return values != null ? (String[])values.clone() : null;
    }

    public void setPublicNavigationalState(QName name, String[] value) throws IllegalArgumentException, IllegalStateException {
        if (!this.modifiable) {
            throw new IllegalStateException("The page navigational state is not modifiable");
        }
        this.page.put(name, (String[])value.clone());
    }

    public void removePublicNavigationalState(QName name) throws IllegalArgumentException, IllegalStateException {
        if (!this.modifiable) {
            throw new IllegalStateException("The page navigational state is not modifiable");
        }
        this.page.remove(name);
    }
}

