/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.EventPhaseContext;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.PortletControllerContextSupport;
import org.gatein.pc.controller.WiringEventControllerContext;
import org.gatein.pc.controller.event.AbstractEventControllerContext;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.event.WindowEvent;
import org.gatein.pc.controller.handlers.EventProducerActionHandler;
import org.gatein.pc.controller.handlers.EventProducerEventHandler;
import org.gatein.pc.controller.handlers.NoOpEventHandler;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.request.PortletRenderRequest;
import org.gatein.pc.controller.response.ControllerResponse;
import org.gatein.pc.controller.response.PageUpdateResponse;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.WindowNavigationalState;
import org.gatein.pc.portlet.support.PortletInvokerSupport;
import org.gatein.pc.portlet.support.PortletSupport;
import org.gatein.pc.portlet.support.info.EventInfoSupport;

public class PortletControllerTestCase
extends TestCase {
    PortletController controller = new PortletController();
    PortletControllerContextSupport context = new PortletControllerContextSupport();
    WiringEventControllerContext eventControllerContext = new WiringEventControllerContext();
    PortletInvokerSupport invoker = this.context.getInvoker();
    public static final QName SRC_NAME = new QName("ns1", "src");
    public static final QName DST_NAME = new QName("ns2", "dest");

    protected void setUp() throws Exception {
        this.context.setEventControllerContext(this.eventControllerContext);
    }

    public void testPortletControllerRenderRequest() throws PortletInvokerException {
        this.invoker.addPortlet("/webapp1:foo");
        OpaqueStateString portletNS = new OpaqueStateString("abc");
        PageNavigationalState pageNS = new PageNavigationalState(true);
        WindowNavigationalState windowNS = new WindowNavigationalState((StateString)portletNS, Mode.EDIT, WindowState.MAXIMIZED);
        PortletRenderRequest render = new PortletRenderRequest("/webapp1:foo", windowNS, new HashMap(), pageNS);
        ControllerResponse response = this.controller.process((ControllerContext)this.context, (ControllerRequest)render);
        PageUpdateResponse pageUpdate = (PageUpdateResponse)response;
        PortletControllerTestCase.assertNotNull((Object)pageUpdate.getPageNavigationalState());
        PageNavigationalState pageNS2 = pageUpdate.getPageNavigationalState();
        PortletControllerTestCase.assertEquals((Object)Tools.toSet((Object[])new String[]{"/webapp1:foo"}), (Object)pageNS2.getWindowIds());
        WindowNavigationalState windowNS2 = pageNS2.getWindowNavigationalState("/webapp1:foo");
        PortletControllerTestCase.assertNotNull((Object)windowNS2);
        PortletControllerTestCase.assertEquals((Object)portletNS, (Object)windowNS2.getPortletNavigationalState());
        PortletControllerTestCase.assertEquals((Object)Mode.EDIT, (Object)windowNS2.getMode());
        PortletControllerTestCase.assertEquals((Object)WindowState.MAXIMIZED, (Object)windowNS2.getWindowState());
    }

    public void testAction() throws PortletInvokerException {
        this.testAction(false);
    }

    public void testActionPublishesAnEvent() throws PortletInvokerException {
        this.testAction(true);
    }

    private void testAction(final boolean publishEvent) throws PortletInvokerException {
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        fooPortlet.addHandler((PortletSupport.InvocationHandler)new PortletSupport.ActionHandler(){

            protected PortletInvocationResponse invoke(ActionInvocation action) throws PortletInvokerException {
                UpdateNavigationalStateResponse updateNS = new UpdateNavigationalStateResponse();
                updateNS.setMode(Mode.EDIT);
                updateNS.setWindowState(WindowState.MAXIMIZED);
                updateNS.setNavigationalState((StateString)new OpaqueStateString("abc"));
                if (publishEvent) {
                    updateNS.queueEvent(new UpdateNavigationalStateResponse.Event(SRC_NAME, null));
                }
                return updateNS;
            }
        });
        PortletSupport barPortlet = this.invoker.addPortlet("/webapp2:bar");
        barPortlet.addHandler((PortletSupport.InvocationHandler)new PortletSupport.EventHandler(){

            protected PortletInvocationResponse invoke(EventInvocation action) throws PortletInvokerException {
                TestCase.assertEquals((Object)DST_NAME, (Object)action.getName());
                TestCase.assertEquals(null, (Object)action.getPayload());
                UpdateNavigationalStateResponse updateNS = new UpdateNavigationalStateResponse();
                updateNS.setMode(Mode.HELP);
                updateNS.setWindowState(WindowState.MINIMIZED);
                updateNS.setNavigationalState((StateString)new OpaqueStateString("def"));
                return updateNS;
            }
        });
        this.eventControllerContext.createWire(SRC_NAME, "/webapp1:foo", DST_NAME, "/webapp2:bar");
        ControllerRequest request = this.context.createActionRequest("/webapp1:foo");
        ControllerResponse response = this.controller.process((ControllerContext)this.context, request);
        PageUpdateResponse pageUpdate = (PageUpdateResponse)response;
        PortletControllerTestCase.assertNotNull((Object)pageUpdate.getPageNavigationalState());
        PageNavigationalState pageNS = pageUpdate.getPageNavigationalState();
        PortletControllerTestCase.assertNotNull((Object)pageNS.getWindowNavigationalState("/webapp1:foo"));
        WindowNavigationalState fooNS = pageNS.getWindowNavigationalState("/webapp1:foo");
        PortletControllerTestCase.assertEquals((Object)WindowState.MAXIMIZED, (Object)fooNS.getWindowState());
        PortletControllerTestCase.assertEquals((Object)Mode.EDIT, (Object)fooNS.getMode());
        PortletControllerTestCase.assertEquals((Object)new OpaqueStateString("abc"), (Object)fooNS.getPortletNavigationalState());
        if (publishEvent) {
            PortletControllerTestCase.assertEquals((Object)Tools.toSet((Object[])new String[]{"/webapp1:foo", "/webapp2:bar"}), (Object)pageNS.getWindowIds());
            PortletControllerTestCase.assertNotNull((Object)pageNS.getWindowNavigationalState("/webapp2:bar"));
            WindowNavigationalState barNS = pageNS.getWindowNavigationalState("/webapp2:bar");
            PortletControllerTestCase.assertEquals((Object)WindowState.MINIMIZED, (Object)barNS.getWindowState());
            PortletControllerTestCase.assertEquals((Object)Mode.HELP, (Object)barNS.getMode());
            PortletControllerTestCase.assertEquals((Object)new OpaqueStateString("def"), (Object)barNS.getPortletNavigationalState());
        } else {
            PortletControllerTestCase.assertEquals((Object)Tools.toSet((Object[])new String[]{"/webapp1:foo"}), (Object)pageNS.getWindowIds());
        }
    }

    public void testActionThrowsPortletInvokerException() throws PortletInvokerException {
        final PortletInvokerException e = new PortletInvokerException();
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        fooPortlet.addHandler((PortletSupport.InvocationHandler)new PortletSupport.ActionHandler(){

            protected PortletInvocationResponse invoke(ActionInvocation action) throws PortletInvokerException {
                throw e;
            }
        });
        ControllerRequest request = this.context.createActionRequest("/webapp1:foo");
        try {
            this.controller.process((ControllerContext)this.context, request);
            PortletControllerTestCase.fail();
        }
        catch (PortletInvokerException ex) {
            PortletControllerTestCase.assertSame((Object)((Object)e), (Object)((Object)ex));
        }
    }

    public void testProcessActionProducedEventIsDistributed() throws PortletInvokerException {
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        PortletSupport barPortlet = this.invoker.addPortlet("/webapp2:bar");
        EventProducerActionHandler eventProducerHandler = new EventProducerActionHandler(SRC_NAME);
        NoOpEventHandler eventConsumer = new NoOpEventHandler();
        this.eventControllerContext.createWire(SRC_NAME, "/webapp1:foo", DST_NAME, "/webapp2:bar");
        ControllerRequest request = this.context.createActionRequest("/webapp1:foo");
        this.controller.setDistributeNonProduceableEvents(true);
        this.controller.setDistributeNonConsumableEvents(true);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerHandler);
        barPortlet.addHandler((PortletSupport.InvocationHandler)eventConsumer);
        this.controller.process((ControllerContext)this.context, request);
        fooPortlet.assertInvocationCountIs(1);
        barPortlet.assertInvocationCountIs(1);
        this.controller.setDistributeNonProduceableEvents(true);
        this.controller.setDistributeNonConsumableEvents(false);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerHandler);
        this.controller.process((ControllerContext)this.context, request);
        fooPortlet.assertInvocationCountIs(2);
        barPortlet.assertInvocationCountIs(1);
        barPortlet.getInfo().getEventing().addConsumedEvent(new EventInfoSupport(DST_NAME));
        this.controller.setDistributeNonProduceableEvents(true);
        this.controller.setDistributeNonConsumableEvents(true);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerHandler);
        barPortlet.addHandler((PortletSupport.InvocationHandler)eventConsumer);
        this.controller.process((ControllerContext)this.context, request);
        fooPortlet.assertInvocationCountIs(3);
        barPortlet.assertInvocationCountIs(2);
        this.controller.setDistributeNonProduceableEvents(true);
        this.controller.setDistributeNonConsumableEvents(false);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerHandler);
        barPortlet.addHandler((PortletSupport.InvocationHandler)eventConsumer);
        this.controller.process((ControllerContext)this.context, request);
        fooPortlet.assertInvocationCountIs(4);
        barPortlet.assertInvocationCountIs(3);
        this.controller.setDistributeNonProduceableEvents(false);
        this.controller.setDistributeNonConsumableEvents(true);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerHandler);
        this.controller.process((ControllerContext)this.context, request);
        fooPortlet.assertInvocationCountIs(5);
        barPortlet.assertInvocationCountIs(3);
        this.controller.setDistributeNonProduceableEvents(false);
        this.controller.setDistributeNonConsumableEvents(false);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerHandler);
        this.controller.process((ControllerContext)this.context, request);
        fooPortlet.assertInvocationCountIs(6);
        barPortlet.assertInvocationCountIs(3);
        fooPortlet.getInfo().getEventing().addProducedEvent(new EventInfoSupport(SRC_NAME));
        this.controller.setDistributeNonProduceableEvents(false);
        this.controller.setDistributeNonConsumableEvents(true);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerHandler);
        barPortlet.addHandler((PortletSupport.InvocationHandler)eventConsumer);
        this.controller.process((ControllerContext)this.context, request);
        fooPortlet.assertInvocationCountIs(7);
        barPortlet.assertInvocationCountIs(4);
        this.controller.setDistributeNonProduceableEvents(false);
        this.controller.setDistributeNonConsumableEvents(false);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerHandler);
        barPortlet.addHandler((PortletSupport.InvocationHandler)eventConsumer);
        this.controller.process((ControllerContext)this.context, request);
        fooPortlet.assertInvocationCountIs(8);
        barPortlet.assertInvocationCountIs(5);
    }

    public void testEventFloodDetection() throws PortletInvokerException {
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        this.eventControllerContext.createWire(SRC_NAME, "/webapp1:foo", SRC_NAME, "/webapp1:foo");
        ControllerRequest request = this.context.createActionRequest("/webapp1:foo");
        EventProducerActionHandler eventProducerActionHandler = new EventProducerActionHandler(SRC_NAME);
        EventProducerEventHandler eventProducerEventHandler = new EventProducerEventHandler(SRC_NAME);
        this.controller.setConsumedEventThreshold(10);
        this.controller.setProducedEventThreshold(1);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerActionHandler);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerEventHandler);
        ControllerResponse response = this.controller.process((ControllerContext)this.context, request);
        PageUpdateResponse updateResponse = (PageUpdateResponse)response;
        PortletControllerTestCase.assertEquals((int)1, (int)updateResponse.getEventDistributionStatus());
        this.controller.setConsumedEventThreshold(1);
        this.controller.setProducedEventThreshold(10);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerActionHandler);
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerEventHandler);
        response = this.controller.process((ControllerContext)this.context, request);
        updateResponse = (PageUpdateResponse)response;
        PortletControllerTestCase.assertEquals((int)1, (int)updateResponse.getEventDistributionStatus());
    }

    public void testEventFloodInterruption() throws PortletInvokerException {
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        this.eventControllerContext.createWire(SRC_NAME, "/webapp1:foo", SRC_NAME, "/webapp1:foo");
        ControllerRequest request = this.context.createActionRequest("/webapp1:foo");
        EventProducerActionHandler eventProducerActionHandler = new EventProducerActionHandler(SRC_NAME);
        this.controller.setConsumedEventThreshold(10);
        this.controller.setProducedEventThreshold(10);
        this.context.setEventControllerContext((EventControllerContext)new AbstractEventControllerContext(){

            public Iterable<WindowEvent> eventProduced(EventPhaseContext context, WindowEvent producedEvent, WindowEvent sourceEvent) {
                return null;
            }
        });
        fooPortlet.addHandler((PortletSupport.InvocationHandler)eventProducerActionHandler);
        ControllerResponse response = this.controller.process((ControllerContext)this.context, request);
        PageUpdateResponse updateResponse = (PageUpdateResponse)response;
        PortletControllerTestCase.assertEquals((int)1, (int)updateResponse.getEventDistributionStatus());
    }
}

