/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.EventPhaseContext;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.event.WindowEvent;

public class WiringEventControllerContext
implements EventControllerContext {
    private final Map<Coordinate, List<Coordinate>> wires = new HashMap<Coordinate, List<Coordinate>>();
    private final List<EventCallback> callbacks = new LinkedList<EventCallback>();

    public Iterable<WindowEvent> eventProduced(EventPhaseContext context, WindowEvent producedEvent, WindowEvent sourceEvent) {
        List<Coordinate> dsts = this.wires.get(new Coordinate(producedEvent.getName(), producedEvent.getWindowId()));
        LinkedList<WindowEvent> toConsume = new LinkedList<WindowEvent>();
        if (dsts != null) {
            for (Coordinate dst : dsts) {
                toConsume.addLast(new WindowEvent(dst.name, producedEvent.getPayload(), dst.windowId));
            }
        }
        return toConsume;
    }

    public void eventConsumed(EventPhaseContext context, WindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
        this.callbacks.add(new EventCallback(0, consumedEvent, consumerResponse));
    }

    public void eventFailed(EventPhaseContext context, WindowEvent failedEvent, Throwable throwable) {
        this.callbacks.add(new EventCallback(1, failedEvent, throwable));
    }

    public void eventDiscarded(EventPhaseContext context, WindowEvent discardedEvent, int cause) {
        this.callbacks.add(new EventCallback(2, discardedEvent, cause));
    }

    public void createWire(QName srcName, String srcWindowId, QName dstName, String dstWindowId) {
        Coordinate dst;
        Coordinate src = new Coordinate(srcName, srcWindowId);
        List<Coordinate> dsts = this.wires.get(src);
        if (dsts == null) {
            dsts = new ArrayList<Coordinate>();
            this.wires.put(src, dsts);
        }
        if (dsts.contains(dst = new Coordinate(dstName, dstWindowId))) {
            throw new IllegalStateException("Such a wire already exists");
        }
        dsts.add(dst);
    }

    private static class Coordinate {
        final QName name;
        final String windowId;

        private Coordinate(QName name, String windowId) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            if (windowId == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.windowId = windowId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Coordinate) {
                Coordinate that = (Coordinate)obj;
                return this.name.equals(that.name) && this.windowId.equals(that.windowId);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.windowId.hashCode();
        }
    }

    public static class EventCallback {
        public static final int EVENT_CONSUMED = 0;
        public static final int EVENT_FAILED = 1;
        public static final int EVENT_DISCARDED = 2;
        private final int type;
        private final WindowEvent event;
        private final Object data;

        private EventCallback(int type, WindowEvent event, Object data) {
            this.type = type;
            this.event = event;
            this.data = data;
        }

        public int getType() {
            return this.type;
        }

        public WindowEvent getEvent() {
            return this.event;
        }

        public PortletInvocationResponse assertConsumed() {
            Assert.assertEquals((int)0, (int)this.type);
            return (PortletInvocationResponse)this.data;
        }

        public Throwable assertFailed() {
            Assert.assertEquals((int)1, (int)this.type);
            return (Throwable)this.data;
        }

        public int assertDiscarded() {
            Assert.assertEquals((int)2, (int)this.type);
            return (Integer)this.data;
        }
    }
}

