/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import java.util.HashMap;
import java.util.Map;
import org.gatein.pc.embed.Chunk;

class Query
extends Chunk {
    final Map<String, String[]> parameters;

    Query(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    Query() {
        this(new HashMap<String, String[]>());
    }

    Chunk put(String key, String value) {
        this.parameters.put(key, new String[]{value});
        return this;
    }

    @Override
    protected void writeTo(StringBuilder sb, String amp) {
        if (this.parameters.size() > 0) {
            String previous = "?";
            for (Map.Entry<String, String[]> parameter : this.parameters.entrySet()) {
                String name = parameter.getKey();
                for (String value : parameter.getValue()) {
                    sb.append(previous);
                    Query.encode(sb, name, QUERY_PARAM);
                    sb.append('=');
                    Query.encode(sb, value, QUERY_PARAM);
                    previous = amp;
                }
            }
        }
    }
}

