/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed.resource;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import junit.framework.Assert;
import org.gatein.common.io.IOTools;
import org.gatein.pc.embed.AbstractTestCase;
import org.gatein.pc.embed.resource.ResourcePortlet;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ResourceTestCase
extends AbstractTestCase {
    @ArquillianResource
    URL deploymentURL;
    @Drone
    WebDriver driver;

    @Deployment
    public static WebArchive deployment() {
        return ResourceTestCase.deployment(ResourcePortlet.class);
    }

    @Test
    @RunAsClient
    @InSequence(value=0)
    public void init() throws Exception {
        Assert.assertEquals((int)0, (int)ResourcePortlet.count);
        URL url = this.deploymentURL.toURI().resolve("embed/ResourcePortlet").toURL();
        this.driver.get(url.toString());
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void updateNavigationalState() throws Exception {
        Assert.assertEquals((int)1, (int)ResourcePortlet.count);
        this.driver.get(ResourcePortlet.navigationURL);
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testParams() {
        Assert.assertEquals((int)2, (int)ResourcePortlet.count);
        Assert.assertEquals((String)"foo_value", (String)ResourcePortlet.foo);
        Assert.assertNull((Object)ResourcePortlet.bar);
        Assert.assertNull((String)"id_value", (Object)ResourcePortlet.resourceId);
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testInteraction() throws Exception {
        WebElement link = this.driver.findElement(By.id((String)"url"));
        URL url = new URL(link.getAttribute("href"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((int)200, (int)conn.getResponseCode());
        String s = new String(IOTools.getBytes((InputStream)conn.getInputStream()));
        Assert.assertEquals((String)"SERVE_RESOURCE", (String)s);
        Map<String, String> headers = ResourceTestCase.responseHeaders(conn);
        Assert.assertEquals((String)"text/plain;charset=utf-8", (String)headers.get("Content-Type"));
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testInvoked() {
        Assert.assertEquals((int)3, (int)ResourcePortlet.count);
        Assert.assertEquals((String)"foo_value", (String)ResourcePortlet.foo);
        Assert.assertEquals((String)"bar_value", (String)ResourcePortlet.bar);
        Assert.assertEquals((String)"id_value", (String)ResourcePortlet.resourceId);
    }
}

