/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import jakarta.servlet.ServletException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.gatein.pc.embed.Chunk;
import org.gatein.pc.embed.Query;
import org.gatein.pc.embed.Segment;
import org.junit.Test;

public class SegmentTestCase {
    @Test
    public void testSegments() {
        this.assertSegments("", null);
        this.assertSegments("/", null);
        this.assertSegments("a", "a");
        this.assertSegments("/a", "a");
        this.assertSegments("foo", "foo");
        this.assertSegments("/foo", "foo");
        this.assertSegments("//foo", "foo");
        this.assertSegments("/foo/", "foo");
        this.assertSegments("/foo//", "foo");
        this.assertSegments("/foo/bar", "foo", "bar");
        this.assertSegments("/foo/bar/", "foo", "bar");
    }

    private void assertSegments(String path, String ... expected) {
        Chunk head;
        try {
            head = Chunk.parse((String)path);
        }
        catch (ServletException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
        if (head instanceof Segment) {
            Assert.assertNotNull((Object)expected);
            Segment first = (Segment)head;
            ArrayList<String> names = new ArrayList<String>();
            for (Segment segment : first) {
                names.add(segment.value);
            }
            Assert.assertEquals((int)first.size(), (int)expected.length);
            Assert.assertEquals(Arrays.asList(expected), names);
        } else {
            Assert.assertNull((Object)expected);
        }
    }

    @Test
    public void testEncoding() {
        Assert.assertEquals((String)"/a/b", (String)new Segment("a", (Chunk)new Segment("b")).toString());
        Assert.assertEquals((String)"/%2F", (String)new Segment("/").toString());
        Assert.assertEquals((String)"/%3B", (String)new Segment(";").toString());
        Assert.assertEquals((String)"/%D0%A3", (String)new Segment("\u0423").toString());
        Assert.assertEquals((String)"/%E2%82%AC", (String)new Segment("\u20ac").toString());
        Assert.assertEquals((String)"/;%3B==", (String)new Segment("", Collections.singletonMap(";", new String[]{"="})).toString());
        Assert.assertEquals((String)"?/=/", (String)new Query().put("/", "/").toString());
    }

    @Test
    public void testDecoding() {
        Assert.assertEquals((String)"a", (String)Chunk.decode((String)"a"));
        Assert.assertEquals((String)"_", (String)Chunk.decode((String)"_"));
        Assert.assertEquals((String)"/", (String)Chunk.decode((String)"/"));
        Assert.assertEquals((String)"0", (String)Chunk.decode((String)"0"));
        Assert.assertEquals((String)"/", (String)Chunk.decode((String)"%2F"));
        Assert.assertEquals((String)"\u0423", (String)Chunk.decode((String)"%D0%A3"));
        Assert.assertEquals((String)"\u20ac", (String)Chunk.decode((String)"%E2%82%AC"));
        Assert.assertEquals((String)"\u00e9", (String)Chunk.decode((String)"\u00e9"));
        Chunk.decode((String)"%E2a");
        Chunk.decode((String)"%z0");
        Chunk.decode((String)"%0");
    }
}

