/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.samples.basic;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.ProcessAction;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class PublicParameterPortlet
extends GenericPortlet {
    @ProcessAction(name="update")
    public void update(ActionRequest req, ActionResponse resp) throws PortletException, IOException {
        Map publicParameters = req.getPublicParameterMap();
        for (Map.Entry actionParameter : req.getPrivateParameterMap().entrySet()) {
            String parameterName = (String)actionParameter.getKey();
            String parameterValue = ((String[])actionParameter.getValue())[0];
            String[] publicValues = (String[])publicParameters.get(parameterName);
            if (parameterValue.length() > 0) {
                if (publicValues != null && publicValues[0].equals(parameterValue)) continue;
                resp.setRenderParameter(parameterName, parameterValue);
                continue;
            }
            if (publicValues == null) continue;
            resp.removePublicRenderParameter(parameterName);
        }
    }

    public void render(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        PortletURL actionURL = resp.createActionURL();
        actionURL.setParameter("javax.portlet.action", "update");
        PrintWriter writer = resp.getWriter();
        writer.print("<form action=\"" + actionURL + "\" method=\"POST\"><table>");
        Enumeration e = this.getPortletConfig().getPublicRenderParameterNames();
        while (e.hasMoreElements()) {
            String parameterName = (String)e.nextElement();
            String parameterValue = req.getParameter(parameterName);
            writer.print("<tr><td>" + parameterName + "</td><td>");
            if (parameterValue != null) {
                writer.print("<input type=\"text\" name=\"" + parameterName + "\" width=\"36\" value=\"" + parameterValue + "\"/>");
                PortletURL renderURL = resp.createRenderURL();
                renderURL.removePublicRenderParameter(parameterName);
                writer.println("<a href=\"" + renderURL + "\">Remove</>");
            } else {
                writer.print("<input type=\"text\" name=\"" + parameterName + "\" width=\"36\" value=\"\"/>");
            }
            writer.println();
            writer.println("</td>");
        }
        writer.println("<input type=\"submit\" value=\"Update\"/>");
        writer.print("</table></form>");
        writer.close();
    }
}

