/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.samples.google;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.namespace.QName;

public class GoogleClippingPortlet
extends GenericPortlet {
    protected static final String A = "<a";
    private static final String A_TARGET_BLANK = "<a target='_blank'";
    private static final String ZIP = "zipcode";
    private static final String BEGINNING_STRING = "beginningString";
    private static final String QUERY = "query";
    public static final QName QNAME = new QName("urn:jboss:portal:samples:event", "ZipEvent");
    private static final String DEFAULT_QUERY = "http://www.google.com/search?gl=US&hl=en&q=";
    private static final String DEFAULT_BEG = "<li class=\"g\"";
    private static final String DEFAULT_ZIP = "94102";
    private static final String END_TABLE = "</table>";
    private static final String BEG_TABLE = "<table";

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        String zip = this.getZipCode(renderRequest);
        String query = this.getQueryString(renderRequest, zip);
        URL url = new URL(query);
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)");
        BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
        String html = new String(this.getBytes((InputStream)in, 16384), "UTF-8");
        in.close();
        String beg = this.getBegString(renderRequest);
        int begIndex = html.indexOf(beg);
        html = begIndex != -1 ? this.process(html, begIndex + beg.length()) : "<p class='portlet-font'>Couldn't retrieve result from Google. Check that '" + beg.replaceAll("<", "&lt;") + "' (value of the <code>beginningString</code> portlet preference) is contained in the result of issued query ('" + query + "', based on the value of the <code>query</code> portlet preference). You can adjust these values in <code>portlet.xml</code> to tweak this portlet output...</p>";
        renderResponse.setContentType("text/html");
        PrintWriter printWriter = renderResponse.getWriter();
        printWriter.print(html);
    }

    private String getBegString(RenderRequest renderRequest) {
        return renderRequest.getPreferences().getValue(BEGINNING_STRING, DEFAULT_BEG);
    }

    private String process(String html, int begIndex) throws IOException {
        int tableIndex = html.indexOf(BEG_TABLE, begIndex);
        int endIndex = html.indexOf(END_TABLE, tableIndex);
        html = html.substring(tableIndex, endIndex + END_TABLE.length());
        html = this.postProcessHTML(html);
        return html;
    }

    protected String getZipCode(RenderRequest renderRequest) {
        String zip = renderRequest.getParameter(ZIP);
        if (zip == null) {
            zip = renderRequest.getPreferences().getValue(ZIP, DEFAULT_ZIP);
        }
        return zip;
    }

    protected void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        renderResponse.setContentType("text/html");
        renderResponse.getWriter().print("<div align='center'>\n   <br/>\n   <form method='post' action='" + renderResponse.createActionURL() + "'>\n      <font class='portlet-font'>Change location (zip code): </font>\n      <input class='portlet-form-input-field' type='text' value='' size='12' name='" + ZIP + "'/>\n      <input class='portlet-form-input-field' type='submit' name='submit' value='submit'/>\n   </form>\n</div>");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String zip = actionRequest.getParameter(ZIP);
        if (null != zip) {
            PortletPreferences prefs = actionRequest.getPreferences();
            prefs.setValue(ZIP, zip);
            prefs.store();
        }
        actionResponse.setRenderParameter(ZIP, zip);
        actionResponse.setPortletMode(PortletMode.VIEW);
        actionResponse.setEvent(QNAME, (Serializable)((Object)zip));
    }

    protected String postProcessHTML(String html) {
        html = html.replaceAll(A, A_TARGET_BLANK);
        html = html.replaceAll("src=/", "src=http://google.com/");
        html = html.replaceAll("src=\"/", "src=\"http://google.com/");
        html = html.replaceAll("action=\"/", "target='_blank' action=\"http://google.com/");
        return html;
    }

    protected String getQueryString(RenderRequest renderRequest, String zip) {
        return renderRequest.getPreferences().getValue(QUERY, DEFAULT_QUERY) + zip;
    }

    private byte[] getBytes(InputStream in, int bufferSize) throws IOException, IllegalArgumentException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        while (true) {
            int i;
            if ((i = in.read(buffer)) == 0) {
                continue;
            }
            if (i == -1) break;
            out.write(buffer, 0, i);
        }
        return out.toByteArray();
    }
}

