/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent;

import java.util.List;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.RuntimeOperationsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgent;
import org.josso.agent.SSOAgentConfiguration;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.util.mbeans.JOSSOBaseMBean;

public class SSOAgentMBean
extends JOSSOBaseMBean {
    public static final String JOSSO_AGENT_EVENT_ADD_PARTNER_APP = "josso.agent.addPartnerApp";
    public static final String JOSSO_AGENT_EVENT_REMOVE_PARTNER_APP = "josso.agent.removePartnerApp";
    private static final Log logger = LogFactory.getLog(SSOAgentMBean.class);
    private int _seq = 0;

    public void addPartnerApp(String id, String vhost, String context, String[] ignoredWebResources) {
        if (context == null) {
            logger.warn((Object)"Tryint to add 'null' context as partner app.");
            return;
        }
        if (ignoredWebResources == null) {
            ignoredWebResources = new String[]{};
        }
        SSOAgent a = this.getSSOAgent();
        SSOAgentConfiguration cfg = a.getConfiguration();
        cfg.addSSOPartnerApp(id, vhost, context, ignoredWebResources, null);
        List<SSOPartnerAppConfig> papps = cfg.getSsoPartnerApps();
        for (int i = 0; i < papps.size(); ++i) {
            SSOPartnerAppConfig papp = papps.get(i);
            if (!papp.getContext().equals(context)) continue;
            SSOAgentMBeanNotification n = new SSOAgentMBeanNotification(JOSSO_AGENT_EVENT_ADD_PARTNER_APP, this.oname, (long)this._seq++);
            n.setUserData(papp);
            try {
                this.sendNotification(n);
                return;
            }
            catch (MBeanException e) {
                logger.warn((Object)("Can't send JMX notificatin : \n" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void addPartnerApp(String id, String vhost, String context) {
        this.addPartnerApp(id, vhost, context, new String[0]);
    }

    public void removePartnerApp(String context) {
        if (context == null) {
            logger.warn((Object)"Trying to remove 'null' context");
            return;
        }
        SSOAgent a = this.getSSOAgent();
        a.getConfiguration().removeSSOPartnerApp(context);
        try {
            SSOAgentMBeanNotification n = new SSOAgentMBeanNotification(JOSSO_AGENT_EVENT_REMOVE_PARTNER_APP, this.oname, (long)this._seq++);
            n.setUserData(context);
            this.sendNotification(n);
        }
        catch (MBeanException e) {
            logger.warn((Object)("Can't send JMX notificatin : \n" + e.getMessage()), (Throwable)e);
        }
    }

    public SSOPartnerAppConfig[] listPartnerApps() {
        SSOAgent a = this.getSSOAgent();
        return a.getConfiguration().getSsoPartnerApps().toArray(new SSOPartnerAppConfig[0]);
    }

    protected SSOAgent getSSOAgent() {
        return (SSOAgent)this.resource;
    }

    public class SSOAgentMBeanNotification
    extends Notification {
        public SSOAgentMBeanNotification(String type, Object source, long sequence) {
            super(type, source, sequence);
        }
    }
}

