/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.gatein.sso.agent.filter.AbstractLogoutFilter;
import org.gatein.sso.agent.josso.JOSSOUtils;
import org.josso.agent.AbstractSSOAgent;

public class JOSSOLogoutFilter
extends AbstractLogoutFilter {
    private AbstractSSOAgent jossoAgent;

    @Override
    protected void initImpl() {
        super.initImpl();
        try {
            this.jossoAgent = JOSSOUtils.lookupSSOAgent();
            if (this.logoutUrl == null || this.logoutUrl.length() == 0) {
                this.logoutUrl = this.jossoAgent.getGatewayLogoutUrl().trim();
                this.log.info((Object)("Obtained logoutUrl from configuration of josso agent. logoutUrl: " + this.logoutUrl));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Can't obtain JOSSO agent", (Throwable)e);
        }
    }

    @Override
    protected String getRedirectUrl(HttpServletRequest httpRequest) {
        try {
            String parameters = URLEncoder.encode("portal:componentId=UIPortal&portal:action=Logout", "UTF-8");
            String partnerAppId = JOSSOUtils.getPartnerAppId(this.jossoAgent, httpRequest);
            StringBuilder builder = new StringBuilder(this.logoutUrl).append("?josso_back_to=").append(httpRequest.getRequestURL()).append("?").append(parameters).append("&josso_partnerapp_id=").append(partnerAppId);
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

