/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.session.service;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.gateway.event.security.SSOSecurityEventManager;
import org.josso.gateway.session.service.BaseSession;
import org.josso.gateway.session.service.SSOSessionManager;

public class BaseSessionImpl
implements BaseSession {
    private static final Log logger = LogFactory.getLog(BaseSessionImpl.class);
    protected String _id;
    protected boolean _valid;
    protected long _creationTime;
    protected int _maxInactiveInterval = -1;
    protected long _lastAccessedTime;
    protected long _accessCount;
    protected boolean _expiring;
    protected String _username;

    public String getId() {
        return this._id;
    }

    public boolean isValid() {
        long timeNow;
        int timeIdle;
        if (!this._valid) {
            return this._valid;
        }
        if (this._maxInactiveInterval >= 0 && (timeIdle = (int)(((timeNow = System.currentTimeMillis()) - this._lastAccessedTime) / 1000L)) >= this._maxInactiveInterval) {
            this.expire();
        }
        return this._valid;
    }

    public void setMaxInactiveInterval(int interval) {
        this._maxInactiveInterval = interval;
        this.isValid();
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public long getLastAccessTime() {
        return this._lastAccessedTime;
    }

    public long getAccessCount() {
        return this._accessCount;
    }

    public void access() {
        this._lastAccessedTime = System.currentTimeMillis();
        this.isValid();
        ++this._accessCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        this.setValid(false);
        if (this._expiring) {
            return;
        }
        BaseSessionImpl baseSessionImpl = this;
        synchronized (baseSessionImpl) {
            this._expiring = true;
            this._accessCount = 0L;
            this.setValid(false);
            this.fireSessionEvent("destroySession", null);
            this._expiring = false;
        }
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setCreationTime(long time) {
        this._creationTime = time;
        this._lastAccessedTime = time;
    }

    public void setValid(boolean valid) {
        this._valid = valid;
    }

    public void fireSessionEvent(String type, Object data) {
        try {
            Lookup.getInstance().lookupSSOGateway().prepareSSOContext(SSOSessionManager.TOKEN_TYPE, this.getId());
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireSessionEvent(this.getUsername(), this.getId(), type, data);
        }
        catch (Exception e) {
            logger.error((Object)("Can't send session event : " + e.getMessage()), (Throwable)e);
        }
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public String toString() {
        return this._id + " [" + this._username + "] " + new Date(this._creationTime);
    }
}

