/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent;

import java.util.EventObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgentMBean;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.util.config.ConfigurationContext;
import org.josso.util.config.SSOConfigurationEventHandler;

public class SSOAgentConfigurationHandler
extends SSOConfigurationEventHandler {
    private static final Log logger = LogFactory.getLog(SSOAgentConfigurationHandler.class);

    public SSOAgentConfigurationHandler(ConfigurationContext ctx, String elementsBaseLocation, String newElementsBaseLocation, Object source, String[] ignoredAttrs) {
        super(ctx, elementsBaseLocation, newElementsBaseLocation, source, ignoredAttrs);
    }

    public boolean isEventEnabled(String eventType, EventObject event) {
        return event instanceof SSOAgentMBean.SSOAgentMBeanNotification;
    }

    public void handleEvent(String eventType, EventObject event) {
        SSOAgentMBean.SSOAgentMBeanNotification notification = (SSOAgentMBean.SSOAgentMBeanNotification)event;
        if (eventType.equals("josso.agent.addPartnerApp")) {
            SSOPartnerAppConfig cfg = (SSOPartnerAppConfig)notification.getUserData();
            this.addSSOPartnerAppConfig(cfg);
        } else if (eventType.equals("josso.agent.removePartnerApp")) {
            String context = (String)notification.getUserData();
            this.removeSSOPartnerAppConfig(context);
        }
    }

    protected void addSSOPartnerAppConfig(SSOPartnerAppConfig cfg) {
        String context = cfg.getContext();
        if (context == null || context.equals("")) {
            logger.error((Object)"addSSOPartnerAppConfig : received context is null or empty");
            return;
        }
        String xml = "            <context>" + cfg.getContext() + "</context>\n";
        if (cfg.getIgnoredWebRources() != null && cfg.getIgnoredWebRources().length > 0) {
            xml = xml + "              <security-constraint>\n";
            for (int i = 0; i < cfg.getIgnoredWebRources().length; ++i) {
                String s = cfg.getIgnoredWebRources()[i];
                xml = xml + "                <ignore-web-resource-collection>" + s + "</ignore-web-resource-collection>\n";
            }
            xml = xml + "              </security-constraint>";
        }
        String qry = this.buildXAppendElementXMLQueryString(this.getElementsBaseLocation(), "partner-app", xml);
        try {
            this.updateConfiguration(qry);
        }
        catch (Exception e) {
            logger.error((Object)("Can't add SSO partner application from to config (" + cfg.getContext() + ")"));
        }
    }

    protected void removeSSOPartnerAppConfig(String context) {
        if (context == null || context.equals("")) {
            logger.error((Object)"removeSSOPartnerAppConfig : received context is null or empty");
            return;
        }
        String qry = this.buildXDeleteElementQuery(this.getElementsBaseLocation(), "partner-app[context='" + context + "']");
        try {
            this.updateConfiguration(qry);
        }
        catch (Exception e) {
            logger.error((Object)("Can't remove SSO partner application from config (" + context + ")"));
        }
    }
}

