/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.login;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class SPNEGORolesModule
extends AbstractServerLoginModule {
    private Identity identity = null;
    private static final String OPTION_PORTAL_CONTAINER_NAME = "portalContainerName";
    private String portalContainerName;

    private String getPortalContainerName(Map options) {
        String optionValue;
        if (options != null && (optionValue = (String)options.get(OPTION_PORTAL_CONTAINER_NAME)) != null && optionValue.length() > 0) {
            return optionValue;
        }
        return PortalContainer.DEFAULT_PORTAL_CONTAINER_NAME;
    }

    private ExoContainer getContainer() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer(this.portalContainerName);
        }
        return container;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.portalContainerName = this.getPortalContainerName(options);
    }

    public boolean login() throws LoginException {
        try {
            if (super.login()) {
                Principal principal = this.getIdentity();
                Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
                this.identity = authenticator.createIdentity(principal.getName());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    protected Principal getIdentity() {
        return (Principal)this.sharedState.get("javax.security.auth.login.name");
    }

    protected Group[] getRoleSets() throws LoginException {
        try {
            SimpleGroup roles = new SimpleGroup("Roles");
            for (String role : this.identity.getRoles()) {
                roles.addMember(this.createIdentity(role));
            }
            Group[] groups = new Group[]{roles};
            return groups;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public boolean commit() throws LoginException {
        try {
            if (super.commit()) {
                IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
                if (identityRegistry.getIdentity(this.identity.getUserId()) != null) {
                    return true;
                }
                this.identity.setSubject(this.subject);
                identityRegistry.register(this.identity);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }
}

