/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.filter.api.SSOInterceptor;
import org.gatein.sso.agent.filter.api.SSOInterceptorInitializationContext;
import org.gatein.sso.saml.plugin.filter.EmptyFilterChain;
import org.gatein.sso.saml.plugin.filter.SAMLFilterConfig;
import org.gatein.sso.saml.plugin.filter.SAMLSPServletContextWrapper;
import org.picketlink.identity.federation.web.filters.SPFilter;

public class SAML2LogoutFilter
extends SPFilter
implements SSOInterceptor {
    public static final String SAML_LOGOUT_ATTRIBUTE = "SAML_LOGOUT_IN_PROGRESS";
    private static final Logger log = LoggerFactory.getLogger(SAML2LogoutFilter.class);
    public static final String COOKIE_NAME = "rememberme";
    public static final String OAUTH_COOKIE_NAME = "oauth_rememberme";
    protected FilterConfig config;
    protected String servletContextName;
    private volatile Boolean requirePortalEnvironment;
    private SSOInterceptorInitializationContext interceptorContext;

    public final void init(FilterConfig config) throws ServletException {
        this.config = this.getFilterConfig(config);
        this.servletContextName = ContainerUtil.getServletContextName((ServletContext)config.getServletContext());
        this.afterInit(config);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        request.setCharacterEncoding("UTF-8");
        if (SAML2LogoutFilter.isPortalLogoutInProgress(request)) {
            if (StringUtils.isBlank((String)SAML2LogoutFilter.getPortalLogoutURLFromSession(request))) {
                HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request){

                    public String getParameter(String name) {
                        if (StringUtils.equals((String)"GLO", (String)name)) {
                            return "true";
                        }
                        return super.getParameter(name);
                    }
                };
                super.doFilter((ServletRequest)requestWrapper, servletResponse, (FilterChain)new EmptyFilterChain());
                request.getSession().setAttribute(SAML_LOGOUT_ATTRIBUTE, (Object)(request.getRequestURI() + "?" + request.getQueryString()));
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
                try {
                    request.getSession().invalidate();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        } else if (SAML2LogoutFilter.isSAMLLogoutInProgress(request)) {
            response.sendRedirect(SAML2LogoutFilter.getPortalLogoutURLFromSession(request));
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private static String getPortalLogoutURLFromSession(HttpServletRequest request) {
        return request.getSession().getAttribute(SAML_LOGOUT_ATTRIBUTE) == null ? null : request.getSession().getAttribute(SAML_LOGOUT_ATTRIBUTE).toString();
    }

    public static boolean isPortalLogoutInProgress(HttpServletRequest request) {
        return StringUtils.equals((String)request.getParameter("portal:action"), (String)"Logout") && request.getRemoteUser() != null;
    }

    public static boolean isSAMLLogoutInProgress(HttpServletRequest request) {
        return request.getRemoteUser() != null && StringUtils.isNotBlank((String)SAML2LogoutFilter.getPortalLogoutURLFromSession(request)) && !StringUtils.equals((String)SAML2LogoutFilter.getPortalLogoutURLFromSession(request), (String)"DONE");
    }

    private final ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = this.interceptorContext.getExoContainer();
        }
        if (container instanceof RootContainer) {
            container = PortalContainer.getInstance();
        }
        return container;
    }

    private final void afterInit(FilterConfig filterConfig) throws ServletException {
        this.interceptorContext = new SSOInterceptorInitializationContext(filterConfig, null, null);
        log.debug((Object)("Interceptor initialized with context " + this.interceptorContext));
        try {
            this.initImpl();
        }
        catch (ServletException e) {
            log.error((Object)"Error initializing SAML Filter", (Throwable)e);
        }
    }

    public final void initWithParams(InitParams params, ExoContainerContext containerContext) {
        this.interceptorContext = new SSOInterceptorInitializationContext(null, params, containerContext);
        this.servletContextName = containerContext.getPortalContainerName();
        log.debug((Object)("Interceptor initialized with context " + this.interceptorContext));
        try {
            this.initImpl();
        }
        catch (ServletException e) {
            log.error((Object)"Error initializing SAML Filter", (Throwable)e);
        }
    }

    protected void initImpl() throws ServletException {
        FilterConfig filterConfig = this.getFilterConfig(null);
        if (this.servletContextName == null) {
            this.servletContextName = ContainerUtil.getServletContextName((ServletContext)this.getServletContext());
        }
        this.configFile = "file:" + this.getInitParameter("CONFIG_FILE");
        super.init(filterConfig);
    }

    protected String getInitParameter(String paramName) {
        return this.interceptorContext.getInitParameter(paramName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requirePortalEnvironment() {
        if (this.requirePortalEnvironment == null) {
            SAML2LogoutFilter sAML2LogoutFilter = this;
            synchronized (sAML2LogoutFilter) {
                if (this.requirePortalEnvironment == null) {
                    this.requirePortalEnvironment = PortalContainer.isPortalContainerName((String)this.servletContextName);
                }
            }
        }
        return this.requirePortalEnvironment;
    }

    protected ServletContext getServletContext() {
        ExoContainer container;
        if (this.requirePortalEnvironment() && (container = this.getContainer()) instanceof PortalContainer) {
            return ((PortalContainer)container).getPortalContext();
        }
        if (this.config != null) {
            return this.config.getServletContext();
        }
        return null;
    }

    private FilterConfig getFilterConfig(FilterConfig config) {
        if (this.config == null) {
            if (config == null) {
                SAMLSPServletContextWrapper servletContext = new SAMLSPServletContextWrapper(this.getServletContext());
                this.config = new SAMLFilterConfig("SAML2LogoutFilter", servletContext, this.interceptorContext);
            } else {
                this.config = config;
            }
        }
        return this.config;
    }
}

