/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.http.FrontChannelParametersBuilder;
import org.josso.agent.http.HttpSSOAgentRequest;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.exceptions.SSOIdentityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpSSOAgent
extends AbstractSSOAgent {
    private static final String JOSSO_LOGIN_URI = "/josso_login/";
    private static final String JOSSO_SECURITY_CHECK_URI = "/josso_security_check";
    private static final String JOSSO_LOGOUT_URI = "/josso_logout/";
    private List<FrontChannelParametersBuilder> _builders = new ArrayList<FrontChannelParametersBuilder>();

    @Override
    public void start() {
        super.start();
    }

    @Override
    protected boolean isAuthenticationAlwaysRequired() {
        return false;
    }

    @Override
    protected void propagateSecurityContext(SSOAgentRequest request, Principal principal) {
        SSOPartnerAppConfig partnerAppConfig;
        HttpSSOAgentRequest servletSSOAgentRequest = (HttpSSOAgentRequest)request;
        String contextPath = servletSSOAgentRequest.getRequest().getContextPath();
        if ("".equals(contextPath)) {
            contextPath = "/";
        }
        if ((partnerAppConfig = this.getPartnerAppConfig(servletSSOAgentRequest.getRequest().getServerName(), contextPath)).getSecurityContextPropagationConfig() == null) {
            return;
        }
        String binding = partnerAppConfig.getSecurityContextPropagationConfig().getBinding();
        String userPlaceHolder = partnerAppConfig.getSecurityContextPropagationConfig().getUserPlaceHolder();
        String rolesPlaceHolder = partnerAppConfig.getSecurityContextPropagationConfig().getRolesPlaceHolder();
        String user = principal.getName();
        if (binding != null && userPlaceHolder != null && rolesPlaceHolder != null) {
            SSORole[] roleSets;
            try {
                roleSets = this.im.findRolesBySSOSessionId(servletSSOAgentRequest.getSessionId());
            }
            catch (SSOIdentityException e) {
                this.log("Error fetching roles for SSO Session [" + servletSSOAgentRequest.getSessionId() + "]" + " on attempting to propagate security context, aborting");
                return;
            }
            HttpServletRequest hreq = servletSSOAgentRequest.getRequest();
            if (binding.equalsIgnoreCase("HTTP_HEADERS")) {
                HashMap headers = new HashMap();
                ArrayList<String> users = new ArrayList<String>();
                users.add(user);
                headers.put(userPlaceHolder, users);
                this.log("Propagated user [" + user + "] onto HTTP Header [" + userPlaceHolder + "]");
                ArrayList<String> roles = new ArrayList<String>();
                for (int i = 0; i < roleSets.length; ++i) {
                    SSORole roleSet = roleSets[i];
                    roles.add(roleSet.getName());
                    this.log("Propagated role [" + roleSet.getName() + "] onto HTTP_HEADERS based security context");
                }
                headers.put(rolesPlaceHolder, roles);
                hreq.setAttribute("org.josso.agent.http.securitycontext.binding", (Object)"HTTP_HEADERS_BINDING");
                hreq.setAttribute("org.josso.agent.http.securitycontext.content", headers);
            }
        }
    }

    public String buildLogoutUrl(HttpServletRequest hreq) {
        String backto = this.buildBackToURL(hreq, "/");
        String logoutUrl = this.getGatewayLogoutUrl() + (backto != null ? "?josso_back_to=" + backto : "");
        logoutUrl = logoutUrl + this.buildLogoutUrlParams(hreq);
        return logoutUrl;
    }

    public String buildLoginUrl(HttpServletRequest hreq) {
        String loginUrl = this.getGatewayLoginUrl();
        String backto = this.buildBackToURL(hreq, this.getJOSSOSecurityCheckUri());
        loginUrl = loginUrl + "?josso_back_to=" + backto;
        loginUrl = loginUrl + this.buildLoginUrlParams(hreq);
        return loginUrl;
    }

    public String buildLoginOptionalUrl(HttpServletRequest hreq) {
        String loginUrl = this.getGatewayLoginUrl();
        String backto = this.buildBackToURL(hreq, this.getJOSSOSecurityCheckUri());
        loginUrl = loginUrl + "?josso_cmd=login_optional&josso_back_to=" + backto;
        loginUrl = loginUrl + this.buildLoginUrlParams(hreq);
        return loginUrl;
    }

    public String buildBackToURL(HttpServletRequest hreq, String uri) {
        String backto = null;
        String contextPath = hreq.getContextPath();
        if (contextPath == null || "".equals(contextPath)) {
            contextPath = "/";
        }
        String reverseProxyHost = hreq.getHeader("Josso-ReversE-Proxy");
        String singlePointOfAccess = this.getSinglePointOfAccess();
        if (singlePointOfAccess != null) {
            if (this.debug >= 1) {
                this.log("josso_back_to option : singlePointOfAccess: " + singlePointOfAccess);
            }
            backto = singlePointOfAccess + contextPath + uri;
        } else if (reverseProxyHost != null) {
            if (this.debug >= 1) {
                this.log("josso_back_to option : reverse-proxy-host: " + reverseProxyHost);
            }
            backto = reverseProxyHost + contextPath + uri;
        } else {
            StringBuffer mySelf = HttpUtils.getRequestURL((HttpServletRequest)hreq);
            try {
                URL url = new URL(mySelf.toString());
                backto = url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            backto = backto + (contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length() - 1) : contextPath) + uri;
        }
        if (this.debug >= 1) {
            this.log("Using josso_back_to : " + backto);
        }
        return backto;
    }

    public Cookie newJossoCookie(String path, String value) {
        if (path == null || "".equals(path)) {
            path = "/";
        }
        Cookie ssoCookie = new Cookie("JOSSO_SESSIONID", value);
        ssoCookie.setMaxAge(-1);
        ssoCookie.setPath(path);
        return ssoCookie;
    }

    protected String buildLoginUrlParams(HttpServletRequest hreq) {
        String urlParams = "";
        for (FrontChannelParametersBuilder builder : this._builders) {
            SSONameValuePair[] params;
            for (SSONameValuePair param : params = builder.buildParamters(hreq)) {
                urlParams = urlParams + "&" + param.getName() + "=" + param.getValue();
            }
        }
        return urlParams;
    }

    protected String buildLogoutUrlParams(HttpServletRequest hreq) {
        String urlParams = "";
        for (FrontChannelParametersBuilder builder : this._builders) {
            SSONameValuePair[] params;
            for (SSONameValuePair param : params = builder.buildParamters(hreq)) {
                urlParams = urlParams + "&" + param.getName() + "=" + param.getValue();
            }
        }
        return urlParams;
    }

    public String getJOSSOLoginUri() {
        return JOSSO_LOGIN_URI;
    }

    public String getJOSSOSecurityCheckUri() {
        return JOSSO_SECURITY_CHECK_URI;
    }

    public String getJOSSOLogoutUri() {
        return JOSSO_LOGOUT_URI;
    }

    public void setParametersBuilders(List<FrontChannelParametersBuilder> builders) {
        this._builders = builders;
    }

    public List<FrontChannelParametersBuilder> getParametersBuilders() {
        return this._builders;
    }
}

