/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.assertion;

import org.josso.gateway.assertion.AuthenticationAssertion;

public class AuthenticationAssertionImpl
implements AuthenticationAssertion {
    private static final int ASSERTION_MAX_AGE = 30;
    protected String id;
    protected String securityDomainName;
    protected boolean isValid = true;
    protected long creationTime;
    protected String ssoSessionId;

    public AuthenticationAssertionImpl(String id) {
        this.id = id;
    }

    public AuthenticationAssertionImpl(String id, String ssoSessionId) {
        this.id = id;
        this.ssoSessionId = ssoSessionId;
        this.creationTime = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public String getSecurityDomainName() {
        return this.securityDomainName;
    }

    public String getSSOSessionId() {
        return this.ssoSessionId;
    }

    public boolean isValid() {
        if (!this.isValid) {
            return this.isValid;
        }
        long timeNow = System.currentTimeMillis();
        int age = (int)((timeNow - this.creationTime) / 1000L);
        if (age > 30) {
            this.expire();
        }
        return this.isValid;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void expire() {
        this.isValid = false;
    }

    public void fireAssertionEvent(String type, Object data) {
        throw new UnsupportedOperationException("Event handling for assertions not yet implemented");
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthenticationAssertion)) {
            return false;
        }
        AuthenticationAssertion aa = (AuthenticationAssertion)obj;
        return aa.getId().equals(this.getId());
    }
}

