/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.opensso;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.util.Base64;
import org.gatein.sso.agent.opensso.CDMessageContext;

class CDMessageParser {
    private static final Logger log = LoggerFactory.getLogger(CDMessageParser.class);
    private static final Pattern SAML_SUCCESS_PATTERN = Pattern.compile("<samlp:StatusCode Value=(.*)>");
    private static final Pattern SAML_DATE_CONDITIONS = Pattern.compile("<saml:Conditions  NotBefore=\"(.*)\" NotOnOrAfter=\"(.*)\" >");
    private static final Pattern IN_RESPONSE_TO_PATTERN = Pattern.compile("InResponseTo=\"([0-9]*)\"");
    private static final Pattern TOKEN_PATTERN = Pattern.compile("<saml:NameIdentifier .*>(.*)</saml:NameIdentifier>");

    CDMessageParser() {
    }

    public CDMessageContext parseMessage(String encodedInputMessage) {
        String group;
        String decodedMessage = this.decodeMessage(encodedInputMessage);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decoded message from CDCServlet: ");
            log.trace((Object)decodedMessage);
        }
        boolean success = false;
        Matcher m = SAML_SUCCESS_PATTERN.matcher(decodedMessage);
        if (m.find() && (group = m.group(1)).contains("samlp:Success")) {
            success = true;
        }
        String beforeDate = null;
        String afterDate = null;
        m = SAML_DATE_CONDITIONS.matcher(decodedMessage);
        if (m.find()) {
            beforeDate = m.group(1);
            afterDate = m.group(2);
        }
        Integer inResponseTo = -1;
        m = IN_RESPONSE_TO_PATTERN.matcher(decodedMessage);
        if (m.find()) {
            inResponseTo = Integer.parseInt(m.group(1));
        }
        String token = null;
        m = TOKEN_PATTERN.matcher(decodedMessage);
        if (m.find()) {
            token = m.group(1);
        }
        try {
            token = URLDecoder.decode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        return new CDMessageContext(success, inResponseTo, beforeDate, afterDate, token);
    }

    String decodeMessage(String encodedInputMessage) {
        byte[] bytes = Base64.decode((String)encodedInputMessage);
        String decodedSamlMessage = new String(bytes);
        return decodedSamlMessage;
    }
}

