/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.integration;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class SSOUtils {
    private static final Logger log = LoggerFactory.getLogger(SSOUtils.class);
    private static boolean ssoEnabled;

    public static boolean isSSOEnabled() {
        return ssoEnabled;
    }

    public static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    public static Class<?> loadClass(final String filterClazz) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                Class<?> clazz;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(filterClazz);
                    if (clazz != null) {
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    clazz = SSOUtils.class.getClassLoader().loadClass(filterClazz);
                    if (clazz != null) {
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    return Class.forName(filterClazz);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Unable to load class " + filterClazz + " with classloaders " + Thread.currentThread().getContextClassLoader() + ", " + SSOUtils.class.getClassLoader() + " and Class.forName", cnfe);
                }
            }
        });
    }

    public static String substituteSystemProperty(String input) {
        String output = SSOUtils.substituteVariable(input);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Substituting value from configuration with System properties - input=" + input + ", output=" + output));
        }
        return output;
    }

    private static String substituteVariable(String val) {
        if (val == null) {
            return val;
        }
        String retval = val;
        while (retval.contains("${")) {
            String prev = retval;
            if (!(retval = SSOUtils._substituteVar(retval)).equals(prev)) continue;
            break;
        }
        return retval;
    }

    private static String _substituteVar(String val) {
        int start_index = val.indexOf("${");
        if (start_index == -1) {
            return val;
        }
        int end_index = val.indexOf("}", start_index + 2);
        if (end_index == -1) {
            throw new IllegalArgumentException("missing \"}\" in " + val);
        }
        String tmp = SSOUtils.getProperty(val.substring(start_index + 2, end_index));
        if (tmp == null) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(val.substring(0, start_index));
        sb.append(tmp);
        sb.append(val.substring(end_index + 1));
        return sb.toString();
    }

    private static String getProperty(String s) {
        String retval = null;
        int index = s.indexOf(":");
        if (index >= 0) {
            String var = s.substring(0, index);
            String default_val = s.substring(index + 1);
            if (default_val != null && default_val.length() > 0) {
                default_val = default_val.trim();
            }
            retval = SSOUtils._getProperty(var, default_val);
        } else {
            String var = s;
            retval = SSOUtils._getProperty(var, null);
        }
        return retval;
    }

    private static String _getProperty(String var, String default_value) {
        if (var == null) {
            return null;
        }
        List<String> list = SSOUtils.parseCommaDelimitedStrings(var);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<String>(1);
            list.add(var);
        }
        String retval = null;
        for (String prop : list) {
            try {
                retval = SSOUtils.getSystemProperty(prop, null);
                if (retval == null) continue;
                return retval;
            }
            catch (Throwable throwable) {
            }
        }
        return default_value;
    }

    private static List<String> parseCommaDelimitedStrings(String l) {
        return SSOUtils.parseStringList(l, ",");
    }

    private static List<String> parseStringList(String l, String separator) {
        LinkedList<String> tmp = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(l, separator);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            tmp.add(t.trim());
        }
        return tmp;
    }

    static {
        String ssoEnabledParam = SSOUtils.getSystemProperty("gatein.sso.enabled", "false");
        ssoEnabled = Boolean.parseBoolean(ssoEnabledParam);
    }
}

