/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service;

import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.gateway.ws._1_1.protocol.FindRolesBySSOSessionIdRequestType;
import org.josso.gateway.ws._1_1.protocol.FindRolesBySSOSessionIdResponseType;
import org.josso.gateway.ws._1_1.protocol.FindUserInSecurityDomainRequestType;
import org.josso.gateway.ws._1_1.protocol.FindUserInSecurityDomainResponseType;
import org.josso.gateway.ws._1_1.protocol.FindUserInSessionRequestType;
import org.josso.gateway.ws._1_1.protocol.FindUserInSessionResponseType;
import org.josso.gateway.ws._1_1.protocol.InvalidSessionErrorType;
import org.josso.gateway.ws._1_1.protocol.NoSuchUserErrorType;
import org.josso.gateway.ws._1_1.protocol.SSOIdentityManagerErrorType;
import org.josso.gateway.ws._1_1.protocol.SSONameValuePairType;
import org.josso.gateway.ws._1_1.protocol.SSORoleType;
import org.josso.gateway.ws._1_1.protocol.SSOUserType;
import org.josso.gateway.ws._1_1.protocol.UserExistsRequestType;
import org.josso.gateway.ws._1_1.protocol.UserExistsResponseType;
import org.josso.gateway.ws._1_1.wsdl.SSOIdentityManager;

public class WebserviceSSOIdentityManager
implements SSOIdentityManagerService {
    private static final Log logger = LogFactory.getLog(WebserviceSSOIdentityManager.class);
    private SSOIdentityManager _wsSSOIdentityManager;
    private int _errorCount;
    private int _processedCount;

    public WebserviceSSOIdentityManager(SSOIdentityManager wsSSOIdentityManager) {
        this._wsSSOIdentityManager = wsSSOIdentityManager;
    }

    public void initialize() {
    }

    public SSOUser findUser(String securityDomain, String username) throws NoSuchUserException, SSOIdentityException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[findUser()] : " + securityDomain + ":" + username));
            }
            FindUserInSecurityDomainRequestType request = new FindUserInSecurityDomainRequestType();
            request.setSecurityDomain(securityDomain);
            request.setUsername(username);
            FindUserInSecurityDomainResponseType response = this._wsSSOIdentityManager.findUserInSecurityDomain(request);
            SSOUser sSOUser = this.adaptSSOUser(response.getSSOUser());
            return sSOUser;
        }
        catch (NoSuchUserErrorType e) {
            throw new NoSuchUserException(e.getUsername());
        }
        catch (SSOIdentityManagerErrorType e) {
            throw new SSOIdentityException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new SSOIdentityException(e.getMessage(), e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new SSOIdentityException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public SSOUser findUserInSession(String sessionId) throws NoSuchUserException, SSOIdentityException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[findUserInSession()] : " + sessionId));
        }
        try {
            FindUserInSessionRequestType request = new FindUserInSessionRequestType(sessionId);
            FindUserInSessionResponseType response = this._wsSSOIdentityManager.findUserInSession(request);
            SSOUser sSOUser = this.adaptSSOUser(response.getSSOUser());
            return sSOUser;
        }
        catch (InvalidSessionErrorType e) {
            throw new SSOIdentityException(e.getMessage());
        }
        catch (NoSuchUserErrorType e) {
            throw new NoSuchUserException(e.getUsername());
        }
        catch (SSOIdentityManagerErrorType e) {
            throw new SSOIdentityException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new SSOIdentityException(e.getMessage(), e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new SSOIdentityException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public SSORole[] findRolesBySSOSessionId(String ssoSessionId) throws SSOIdentityException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[findRolesBySSOSessionId()] : " + ssoSessionId));
            }
            FindRolesBySSOSessionIdRequestType request = new FindRolesBySSOSessionIdRequestType();
            request.setSsoSessionId(ssoSessionId);
            FindRolesBySSOSessionIdResponseType response = this._wsSSOIdentityManager.findRolesBySSOSessionId(request);
            SSORole[] sSORoleArray = this.adaptSSORoles(response.getRoles());
            return sSORoleArray;
        }
        catch (InvalidSessionErrorType e) {
            throw new SSOIdentityException(e.getMessage());
        }
        catch (SSOIdentityManagerErrorType e) {
            throw new SSOIdentityException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new SSOIdentityException(e.getMessage(), e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new SSOIdentityException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public void userExists(String securityDomain, String username) throws NoSuchUserException, SSOIdentityException {
        try {
            UserExistsRequestType request;
            UserExistsResponseType response;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[userExists()] : " + username));
            }
            if (!(response = this._wsSSOIdentityManager.userExists(request = new UserExistsRequestType(securityDomain, username))).isUserexists()) {
                throw new NoSuchUserException(username);
            }
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new SSOIdentityException(e.getMessage(), e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new SSOIdentityException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    protected SSOUser adaptSSOUser(SSOUserType srcSSOUser) {
        BaseUserImpl targetSSOUser = new BaseUserImpl();
        targetSSOUser.setName(srcSSOUser.getName());
        SSONameValuePair[] properties = new SSONameValuePair[srcSSOUser.getProperties().length];
        for (int i = 0; i < srcSSOUser.getProperties().length; ++i) {
            SSONameValuePairType nvpt = srcSSOUser.getProperties()[i];
            properties[i] = new SSONameValuePair(nvpt.getName(), nvpt.getValue());
        }
        targetSSOUser.setProperties(properties);
        return targetSSOUser;
    }

    protected SSONameValuePair adaptSSOValuePair(SSONameValuePair srcSSONameValuePair) {
        BaseUserImpl targetSSOUser = new BaseUserImpl();
        SSONameValuePair targetSSONameValuePair = new SSONameValuePair(srcSSONameValuePair.getName(), srcSSONameValuePair.getValue());
        return targetSSONameValuePair;
    }

    protected SSORole adaptSSORole(SSORoleType srcSSORole) {
        BaseRoleImpl targetSSORole = new BaseRoleImpl();
        targetSSORole.setName(srcSSORole.getName());
        return targetSSORole;
    }

    protected SSORole[] adaptSSORoles(SSORoleType[] srcSSORoles) {
        ArrayList<SSORole> targetSSORoles = new ArrayList<SSORole>();
        for (int i = 0; i < srcSSORoles.length; ++i) {
            targetSSORoles.add(this.adaptSSORole(srcSSORoles[i]));
        }
        return targetSSORoles.toArray(new BaseRoleImpl[targetSSORoles.size()]);
    }

    public int getErrorCount() {
        return this._errorCount;
    }

    public int getProcessedCount() {
        return this._processedCount;
    }
}

