/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.josso.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gatein.sso.plugin.RestCallbackCaller;

public class AbstractIdentityPlugin {
    private static final Log log = LogFactory.getLog(AbstractIdentityPlugin.class);
    private static final String PROPERTIES_FILENAME = "gatein.properties";
    private RestCallbackCaller restCallbackCaller;

    public AbstractIdentityPlugin() {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            is = this.loadInputStream();
            properties.load(is);
            String gateInHost = properties.getProperty("host");
            String gateInPort = properties.getProperty("port");
            String gateInContext = properties.getProperty("context");
            String gateInProtocol = properties.getProperty("protocol");
            String gateInHttpMethod = properties.getProperty("httpMethod");
            log.debug((Object)("GateIn Host: " + gateInHost + ", GateIn Port: " + gateInPort + ", GateIn context: " + gateInContext + ", Protocol=" + gateInProtocol + ", http method=" + gateInHttpMethod));
            this.restCallbackCaller = new RestCallbackCaller(gateInProtocol, gateInHost, gateInPort, gateInContext, gateInHttpMethod);
            log.info((Object)"GateIn Identity Plugin successfully started");
        }
        catch (Exception e) {
            throw new RuntimeException("GateIn Identity Plugin registration failed....", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean bindImpl(String username, String password) throws Exception {
        log.debug((Object)"Performing Authentication........................");
        log.debug((Object)("Username: " + username));
        boolean success = this.restCallbackCaller.executeRemoteCall(username, password);
        return success;
    }

    protected InputStream loadInputStream() throws FileNotFoundException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES_FILENAME);
        if (is != null) {
            return is;
        }
        File f = new File(PROPERTIES_FILENAME);
        if (!f.exists()) {
            f = new File("etc/gatein.properties");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File couldn't be loaded from resources of current classloader and also not available on path " + f.getAbsolutePath());
        }
        return new FileInputStream(f);
    }
}

