/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin;

import io.undertow.servlet.api.DeploymentInfo;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.picketlink.identity.federation.bindings.wildfly.sp.SPServletExtension;

public class EXOSPServletExtension
extends SPServletExtension {
    private PortalContainerConfig containerConfig = null;

    public EXOSPServletExtension() {
        if (this.isPortalContainerActivated() && this.containerConfig == null) {
            this.containerConfig = (PortalContainerConfig)RootContainer.getInstance().getComponentInstanceOfType(PortalContainerConfig.class);
        }
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        String property;
        String contextName;
        if (!this.isPortalContainerActivated()) {
            return;
        }
        String string = contextName = servletContext.getContextPath().startsWith("/") ? servletContext.getContextPath().substring(1) : servletContext.getContextPath();
        if (this.containerConfig.isPortalContainerName(contextName) && !this.containerConfig.isPortalContainerNameDisabled(contextName) && StringUtils.isNotBlank((String)(property = System.getProperty("gatein.sso.saml.sp.enabled"))) && "true".equalsIgnoreCase(property.trim())) {
            String samlConfigFile = System.getProperty("gatein.sso.saml.config.file");
            servletContext.setInitParameter("CONFIG_FILE", samlConfigFile);
            super.handleDeployment(deploymentInfo, servletContext);
        }
    }

    private boolean isPortalContainerActivated() {
        try {
            Class.forName("org.exoplatform.container.RootContainer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

