/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.gatein.sso.plugin.RestCallbackCaller;
import org.gatein.sso.saml.plugin.SimpleGroup;
import org.gatein.sso.saml.plugin.SimplePrincipal;

public class SAML2IdpLoginModule
implements LoginModule {
    private static final String OPTION_ROLES_PROCESSING = "rolesProcessing";
    private static final String OPTION_STATIC_ROLES_LIST = "staticRolesList";
    private static final String OPTION_GATEIN_URL = "gateInURL";
    private static final String OPTION_HTTP_METHOD = "httpMethod";
    private static Logger log = Logger.getLogger(SAML2IdpLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private String gateInURL;
    private String httpMethod;
    private ROLES_PROCESSING_TYPE rolesProcessingType;
    private List<String> staticRolesList;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        String rolesProcessingType = this.readOption(OPTION_ROLES_PROCESSING, "STATIC");
        this.rolesProcessingType = "STATIC".equals(rolesProcessingType) || "PORTAL_CALLBACK".equals(rolesProcessingType) ? ROLES_PROCESSING_TYPE.valueOf(rolesProcessingType) : ROLES_PROCESSING_TYPE.STATIC;
        String staticRoles = this.readOption(OPTION_STATIC_ROLES_LIST, "users");
        this.staticRolesList = Arrays.asList(staticRoles.split(","));
        this.gateInURL = this.readOption(OPTION_GATEIN_URL, "http://localhost:8080/portal");
        this.httpMethod = this.readOption(OPTION_HTTP_METHOD, "POST");
    }

    @Override
    public boolean login() throws LoginException {
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            ((PasswordCallback)callbacks[1]).clearPassword();
            if (username == null || password == null) {
                return false;
            }
            boolean authenticationSuccess = this.validateUser(username, password);
            if (authenticationSuccess) {
                log.debug((Object)("Successful REST login request for authentication of user " + username));
                this.sharedState.put("javax.security.auth.login.name", username);
                return true;
            }
            String message = "Remote login via REST failed for username " + username;
            log.warn((Object)message);
            throw new LoginException(message);
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e) {
            log.warn((Object)("Exception during login: " + e.getMessage()), (Throwable)e);
            throw new LoginException(e.getMessage());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        String username = (String)this.sharedState.get("javax.security.auth.login.name");
        Set<Principal> principals = this.subject.getPrincipals();
        SimpleGroup roleGroup = new SimpleGroup("Roles");
        for (String role : this.getRoles(username)) {
            roleGroup.addMember(new SimplePrincipal(role));
        }
        principals.add(roleGroup);
        principals.add(new SimplePrincipal(username));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        HashSet<Principal> principals = new HashSet<Principal>(this.subject.getPrincipals());
        for (Principal p : principals) {
            this.subject.getPrincipals().remove(p);
        }
        return true;
    }

    protected boolean validateUser(String username, String password) throws Exception {
        RestCallbackCaller restCallbackCaller = new RestCallbackCaller(this.gateInURL, this.httpMethod);
        return restCallbackCaller.executeRemoteCall(username, password);
    }

    protected Collection<String> getRoles(String username) {
        if (this.rolesProcessingType == ROLES_PROCESSING_TYPE.STATIC) {
            return this.staticRolesList;
        }
        StringBuilder urlBuffer = new StringBuilder();
        urlBuffer.append(this.gateInURL + "/rest/sso/authcallback/roles/" + username);
        String url = urlBuffer.toString();
        log.debug((Object)("Execute callback HTTP request: " + url));
        ResponseContext responseContext = this.executeRemoteCall(url);
        if (responseContext.status == 200) {
            String rolesString = responseContext.response;
            String[] roles = rolesString.split(",");
            return Arrays.asList(roles);
        }
        log.warn((Object)("Incorrect response received from REST callback for roles. Status=" + responseContext.status + ", Response=" + responseContext.response));
        return new ArrayList<String>();
    }

    private String readOption(String key, String defaultValue) {
        String result = (String)this.options.get(key);
        if (result == null) {
            result = defaultValue;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read option " + key + "=" + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseContext executeRemoteCall(String authUrl) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            String response;
            HttpGet method = new HttpGet(authUrl);
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)method);
            int status = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            String string = response = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received response from REST call: status=" + status + ", response=" + response));
            }
            ResponseContext responseContext = new ResponseContext(status, response);
            return responseContext;
        }
        catch (Exception e) {
            log.warn((Object)"Error when sending request through HTTP client", (Throwable)e);
            ResponseContext responseContext = new ResponseContext(1000, e.getMessage());
            return responseContext;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static enum ROLES_PROCESSING_TYPE {
        STATIC,
        PORTAL_CALLBACK;

    }

    private static class ResponseContext {
        private final int status;
        private final String response;

        private ResponseContext(int status, String response) {
            this.status = status;
            this.response = response;
        }
    }
}

