/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SetPluginSchemaPropertiesViewBeanURL
extends SchemaCommand {
    private static final String ARGUMENT_URL = "url";
    private static final String ARGUMENT_PLUGIN_NAME = "pluginname";
    private static final String ARGUMENT_INTERFACE_NAME = "interfacename";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String url = this.getStringOptionValue(ARGUMENT_URL);
        String interfaceName = this.getStringOptionValue(ARGUMENT_INTERFACE_NAME);
        String pluginName = this.getStringOptionValue(ARGUMENT_PLUGIN_NAME);
        ServiceSchemaManager ssm = this.getServiceSchemaManager();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, pluginName};
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_PLUGIN_SCHEMA_PROP_VIEWBEAN_URL", params);
            PluginSchema ps = ssm.getPluginSchema(pluginName, interfaceName, "/");
            ps.setPropertiesViewBeanURL(url);
            this.writeLog(0, Level.INFO, "SUCCEED_SET_PLUGIN_SCHEMA_PROP_VIEWBEAN_URL", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("add-plugin-interface-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, pluginName, e.getMessage()};
            this.debugError("SetPluginSchemaPropertiesViewBeanURL.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_PLUGIN_SCHEMA_PROP_VIEWBEAN_URL", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, pluginName, e.getMessage()};
            this.debugError("SetPluginSchemaPropertiesViewBeanURL.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_PLUGIN_SCHEMA_PROP_VIEWBEAN_URL", args);
            throw new CLIException(e, 127);
        }
    }
}

