/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.Debugger;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateService
extends AuthenticatedCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        boolean continueFlag = this.isOptionSet("continue");
        IOutput outputWriter = this.getOutputWriter();
        List xmlFiles = rc.getOption("xmlfile");
        ServiceManager ssm = null;
        try {
            ssm = new ServiceManager(adminSSOToken);
        }
        catch (SMSException e) {
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            throw new CLIException((Throwable)((Object)e), 127);
        }
        CommandManager mgr = this.getCommandManager();
        String url = mgr.getWebEnabledURL();
        if (url != null && url.length() > 0) {
            String strXML = (String)xmlFiles.iterator().next();
            try {
                List serviceNames = this.getServiceNames(SMSSchema.getXMLDocument(strXML, true));
                this.deleteServices(rc, ssm, serviceNames, adminSSOToken, continueFlag, outputWriter);
                this.loadSchemaXML(ssm, strXML);
                outputWriter.printlnMessage(this.getResourceString("service-updated"));
            }
            catch (SMSException e) {
                throw new CLIException(e, 127);
            }
        }
        for (String file : xmlFiles) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                List serviceNames = this.getServiceNames(SMSSchema.getXMLDocument(fis));
                this.deleteServices(rc, ssm, serviceNames, adminSSOToken, continueFlag, outputWriter);
                this.loadSchema(ssm, file);
                outputWriter.printlnMessage(this.getResourceString("service-updated"));
            }
            catch (CLIException e) {
                if (continueFlag) {
                    outputWriter.printlnError(this.getResourceString("service-updated-failed") + e.getMessage());
                    if (!this.isVerbose()) continue;
                    outputWriter.printlnError(Debugger.getStackTrace(e));
                    continue;
                }
                throw e;
            }
            catch (SMSException e) {
                if (continueFlag) {
                    outputWriter.printlnError(this.getResourceString("service-updated-failed") + e.getMessage());
                    if (!this.isVerbose()) continue;
                    outputWriter.printlnError(Debugger.getStackTrace(e));
                    continue;
                }
                throw new CLIException(e, 127);
            }
            catch (FileNotFoundException e) {
                if (continueFlag) {
                    outputWriter.printlnError(this.getResourceString("service-updated-failed") + e.getMessage());
                    if (!this.isVerbose()) continue;
                    outputWriter.printlnError(Debugger.getStackTrace(e));
                    continue;
                }
                throw new CLIException(e, 127);
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException ie) {}
            }
        }
    }

    private void loadSchema(ServiceManager ssm, String fileName) throws CLIException {
        String[] param = new String[]{fileName};
        this.writeLog(0, Level.INFO, "ATTEMPT_LOAD_SCHEMA", param);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            ssm.registerServices(fis);
        }
        catch (IOException e) {
            String[] args = new String[]{fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ie) {}
            }
        }
    }

    private void loadSchemaXML(ServiceManager ssm, String xml) throws CLIException {
        String[] param = new String[]{"web-input"};
        this.writeLog(0, Level.INFO, "ATTEMPT_LOAD_SCHEMA", param);
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(xml.getBytes());
            ssm.registerServices(bis);
        }
        catch (SSOException e) {
            String[] args = new String[]{"web-input", e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{"web-input", e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ie) {}
            }
        }
    }

    private List getServiceNames(Document doc) {
        ArrayList<String> serviceNames = new ArrayList<String>();
        NodeList nodes = doc.getElementsByTagName("Service");
        if (nodes != null) {
            int len = nodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node serviceNode = nodes.item(i);
                String name = XMLUtils.getNodeAttributeValue((Node)serviceNode, (String)"name");
                if (name == null || name.length() <= 0) continue;
                serviceNames.add(name);
            }
        }
        return serviceNames;
    }

    private void deleteServices(RequestContext rc, ServiceManager ssm, List serviceNames, SSOToken adminSSOToken, boolean continueFlag, IOutput outputWriter) throws CLIException {
        for (String name : serviceNames) {
            try {
                String[] param = new String[]{name};
                this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_SERVICE", param);
                this.deleteService(rc, ssm, name, adminSSOToken);
                this.writeLog(0, Level.INFO, "SUCCEED_DELETE_SERVICE", param);
            }
            catch (CLIException e) {
                if (continueFlag) {
                    if (!this.isVerbose()) continue;
                    outputWriter.printlnError(Debugger.getStackTrace(e));
                    continue;
                }
                throw e;
            }
        }
    }

    private void deleteService(RequestContext rc, ServiceManager ssm, String serviceName, SSOToken adminSSOToken) throws CLIException {
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminSSOToken);
            if (scm.getGlobalConfig(null) != null) {
                scm.removeGlobalConfiguration(null);
            }
            ssm.deleteService(serviceName);
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_DELETE_SERVICE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_DELETE_SERVICE", args);
            throw new CLIException(e, 127);
        }
    }
}

